/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.tag;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.tag.TagByte;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagDouble;
import at.syntaxerror.syntaxnbt.tag.TagEnd;
import at.syntaxerror.syntaxnbt.tag.TagFloat;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLong;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagShort;
import at.syntaxerror.syntaxnbt.tag.TagString;
import java.util.HashMap;
import java.util.Map;

public enum TagType {
    END(0, "TAG_End", TagEnd.class),
    BYTE(1, "TAG_Byte", TagByte.class),
    SHORT(2, "TAG_Short", TagShort.class),
    INT(3, "TAG_Int", TagInt.class),
    LONG(4, "TAG_Long", TagLong.class),
    FLOAT(5, "TAG_Float", TagFloat.class),
    DOUBLE(6, "TAG_Double", TagDouble.class),
    BYTE_ARRAY(7, "TAG_Byte_Array", TagByteArray.class),
    STRING(8, "TAG_String", TagString.class),
    LIST(9, "TAG_List", TagList.class),
    COMPOUND(10, "TAG_Compound", TagCompound.class),
    INT_ARRAY(11, "TAG_Int_Array", TagIntArray.class),
    LONG_ARRAY(12, "TAG_Long_Array", TagLongArray.class);

    private static final Map<Class<?>, TagType> CLASS_MAPPING;
    private static final Map<Integer, TagType> ID_MAPPING;
    private final int id;
    private final String name;
    private final Class<?> tagClass;

    public static TagType getTypeFromClass(Class<?> clazz) {
        if (!CLASS_MAPPING.containsKey(clazz)) {
            throw new NBTException("Unrecognized Tag class: " + clazz);
        }
        return CLASS_MAPPING.get(clazz);
    }

    public static TagType getTypeFromId(int id) {
        if (!ID_MAPPING.containsKey(id)) {
            throw new NBTException("Unrecognized Tag id: " + id);
        }
        return ID_MAPPING.get(id);
    }

    public String toString() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getTagClass() {
        return this.tagClass;
    }

    private TagType(int id, String name, Class<?> tagClass) {
        this.id = id;
        this.name = name;
        this.tagClass = tagClass;
    }

    static {
        CLASS_MAPPING = new HashMap();
        ID_MAPPING = new HashMap<Integer, TagType>();
        for (TagType type : TagType.values()) {
            CLASS_MAPPING.put(type.getTagClass(), type);
            ID_MAPPING.put(type.getId(), type);
        }
    }
}

