/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.tag;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagByte;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagDouble;
import at.syntaxerror.syntaxnbt.tag.TagFloat;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagLong;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagShort;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TagList<T extends Tag<?>>
extends Tag<List<T>>
implements Iterable<T> {
    private TagType componentType;

    public static TagList<Tag<?>> emptyList() {
        return new TagList();
    }

    public TagList(Class<T> typeClass) {
        this(typeClass, List.of());
    }

    public TagList(Class<T> typeClass, Collection<T> elements) {
        super(TagType.LIST, new ArrayList<T>(elements));
        this.componentType = TagType.getTypeFromClass(typeClass);
        if (this.componentType == TagType.END) {
            throw new NBTException("Cannot create TAG_List for TAG_End");
        }
    }

    private TagList() {
        super(TagType.LIST, new ArrayList());
        this.componentType = null;
    }

    private TagType check(Class<?> clazz) {
        TagType type = TagType.getTypeFromClass(clazz);
        if (this.componentType == null) {
            this.componentType = type;
        } else if (type != this.componentType) {
            throw new NBTException("Incompatible type " + type + " for TAG_List[" + this.componentType + "]");
        }
        return type;
    }

    private <V, X extends Tag<V>> T process(V value, Class<X> clazz) {
        try {
            return (T)((Tag)this.check(clazz).getTagClass().getConstructor(value.getClass()).newInstance(value));
        }
        catch (NBTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NBTException(e);
        }
    }

    private <X extends Tag<?>> T processTag(X value, Class<X> clazz) {
        this.check(clazz);
        return (T)value;
    }

    public T get(int index) {
        return (T)((Tag)((List)this.getValue()).get(index));
    }

    private <X extends Tag<?>> X get(int index, Class<X> clazz) {
        TagType type = TagType.getTypeFromClass(clazz);
        if (this.componentType != null && type != this.componentType) {
            throw new NBTException("Cannot get " + type + " from TAG_List[" + this.componentType + "]");
        }
        return (X)this.get(index);
    }

    public byte getByte(int index) {
        return (Byte)this.getByteTag(index).getValue();
    }

    public short getShort(int index) {
        return (Short)this.getShortTag(index).getValue();
    }

    public int getInt(int index) {
        return (Integer)this.getIntTag(index).getValue();
    }

    public long getLong(int index) {
        return (Long)this.getLongTag(index).getValue();
    }

    public float getFloat(int index) {
        return ((Float)this.getFloatTag(index).getValue()).floatValue();
    }

    public double getDouble(int index) {
        return (Double)this.getDoubleTag(index).getValue();
    }

    public byte[] getByteArray(int index) {
        return (byte[])this.getByteArrayTag(index).getValue();
    }

    public int[] getIntArray(int index) {
        return (int[])this.getIntArrayTag(index).getValue();
    }

    public long[] getLongArray(int index) {
        return (long[])this.getLongArrayTag(index).getValue();
    }

    public String getString(int index) {
        return (String)this.getStringTag(index).getValue();
    }

    public TagByte getByteTag(int index) {
        return this.get(index, TagByte.class);
    }

    public TagShort getShortTag(int index) {
        return this.get(index, TagShort.class);
    }

    public TagInt getIntTag(int index) {
        return this.get(index, TagInt.class);
    }

    public TagLong getLongTag(int index) {
        return this.get(index, TagLong.class);
    }

    public TagFloat getFloatTag(int index) {
        return this.get(index, TagFloat.class);
    }

    public TagDouble getDoubleTag(int index) {
        return this.get(index, TagDouble.class);
    }

    public TagByteArray getByteArrayTag(int index) {
        return this.get(index, TagByteArray.class);
    }

    public TagIntArray getIntArrayTag(int index) {
        return this.get(index, TagIntArray.class);
    }

    public TagLongArray getLongArrayTag(int index) {
        return this.get(index, TagLongArray.class);
    }

    public TagString getStringTag(int index) {
        return this.get(index, TagString.class);
    }

    public TagCompound getCompound(int index) {
        return this.get(index, TagCompound.class);
    }

    public TagList<?> getList(int index) {
        return this.get(index, TagList.class);
    }

    public TagList<T> add(T value) {
        this.addTag(this.size(), (Tag)value, (Class)value.getClass());
        return this;
    }

    public TagList<T> addByte(byte value) {
        return this.add(this.size(), value, TagByte.class);
    }

    public TagList<T> addShort(short value) {
        return this.add(this.size(), value, TagShort.class);
    }

    public TagList<T> addInt(int value) {
        return this.add(this.size(), value, TagInt.class);
    }

    public TagList<T> addLong(long value) {
        return this.add(this.size(), value, TagLong.class);
    }

    public TagList<T> addFloat(float value) {
        return this.add(this.size(), Float.valueOf(value), TagFloat.class);
    }

    public TagList<T> addDouble(double value) {
        return this.add(this.size(), value, TagDouble.class);
    }

    public TagList<T> addByteArray(byte[] value) {
        return this.add(this.size(), value, TagByteArray.class);
    }

    public TagList<T> addIntArray(int[] value) {
        return this.add(this.size(), value, TagIntArray.class);
    }

    public TagList<T> addLongArray(long[] value) {
        return this.add(this.size(), value, TagLongArray.class);
    }

    public TagList<T> addString(String value) {
        return this.add(this.size(), value, TagString.class);
    }

    public TagList<T> addByteTag(TagByte value) {
        return this.addTag(this.size(), value, TagByte.class);
    }

    public TagList<T> addShortTag(TagShort value) {
        return this.addTag(this.size(), value, TagShort.class);
    }

    public TagList<T> addIntTag(TagInt value) {
        return this.addTag(this.size(), value, TagInt.class);
    }

    public TagList<T> addLongTag(TagLong value) {
        return this.addTag(this.size(), value, TagLong.class);
    }

    public TagList<T> addFloatTag(TagFloat value) {
        return this.addTag(this.size(), value, TagFloat.class);
    }

    public TagList<T> addDoubleTag(TagDouble value) {
        return this.addTag(this.size(), value, TagDouble.class);
    }

    public TagList<T> addByteArrayTag(TagByteArray value) {
        return this.addTag(this.size(), value, TagByteArray.class);
    }

    public TagList<T> addIntArrayTag(TagIntArray value) {
        return this.addTag(this.size(), value, TagIntArray.class);
    }

    public TagList<T> addLongArrayTag(TagLongArray value) {
        return this.addTag(this.size(), value, TagLongArray.class);
    }

    public TagList<T> addStringTag(TagString value) {
        return this.addTag(this.size(), value, TagString.class);
    }

    public TagList<T> addCompound(TagCompound value) {
        return this.addTag(this.size(), value, TagCompound.class);
    }

    public TagList<T> addList(TagList<?> value) {
        return this.addTag(this.size(), value, TagList.class);
    }

    public TagList<T> add(int index, T value) {
        this.addTag(index, (Tag)value, (Class)value.getClass());
        return this;
    }

    private <V, X extends Tag<V>> TagList<T> add(int index, V value, Class<X> clazz) {
        ((List)this.getValue()).add(index, this.process(value, clazz));
        return this;
    }

    private <X extends Tag<?>> TagList<T> addTag(int index, X value, Class<X> clazz) {
        ((List)this.getValue()).add(index, this.processTag(value, clazz));
        return this;
    }

    public TagList<T> addByte(int index, byte value) {
        return this.add(index, value, TagByte.class);
    }

    public TagList<T> addShort(int index, short value) {
        return this.add(index, value, TagShort.class);
    }

    public TagList<T> addInt(int index, int value) {
        return this.add(index, value, TagInt.class);
    }

    public TagList<T> addLong(int index, long value) {
        return this.add(index, value, TagLong.class);
    }

    public TagList<T> addFloat(int index, float value) {
        return this.add(index, Float.valueOf(value), TagFloat.class);
    }

    public TagList<T> addDouble(int index, double value) {
        return this.add(index, value, TagDouble.class);
    }

    public TagList<T> addByteArray(int index, byte[] value) {
        return this.add(index, value, TagByteArray.class);
    }

    public TagList<T> addIntArray(int index, int[] value) {
        return this.add(index, value, TagIntArray.class);
    }

    public TagList<T> addLongArray(int index, long[] value) {
        return this.add(index, value, TagLongArray.class);
    }

    public TagList<T> addString(int index, String value) {
        return this.add(index, value, TagString.class);
    }

    public TagList<T> addByteTag(int index, TagByte value) {
        return this.addTag(index, value, TagByte.class);
    }

    public TagList<T> addShortTag(int index, TagShort value) {
        return this.addTag(index, value, TagShort.class);
    }

    public TagList<T> addIntTag(int index, TagInt value) {
        return this.addTag(index, value, TagInt.class);
    }

    public TagList<T> addLongTag(int index, TagLong value) {
        return this.addTag(index, value, TagLong.class);
    }

    public TagList<T> addFloatTag(int index, TagFloat value) {
        return this.addTag(index, value, TagFloat.class);
    }

    public TagList<T> addDoubleTag(int index, TagDouble value) {
        return this.addTag(index, value, TagDouble.class);
    }

    public TagList<T> addByteArrayTag(int index, TagByteArray value) {
        return this.addTag(index, value, TagByteArray.class);
    }

    public TagList<T> addIntArrayTag(int index, TagIntArray value) {
        return this.addTag(index, value, TagIntArray.class);
    }

    public TagList<T> addLongArrayTag(int index, TagLongArray value) {
        return this.addTag(index, value, TagLongArray.class);
    }

    public TagList<T> addStringTag(int index, TagString value) {
        return this.addTag(index, value, TagString.class);
    }

    public TagList<T> addCompound(int index, TagCompound value) {
        return this.addTag(index, value, TagCompound.class);
    }

    public TagList<T> addList(int index, TagList<?> value) {
        return this.addTag(index, value, TagList.class);
    }

    public TagList<T> set(int index, T value) {
        this.setTag(index, (Tag)value, (Class)value.getClass());
        return this;
    }

    private <V, X extends Tag<V>> TagList<T> set(int index, V value, Class<X> clazz) {
        ((List)this.getValue()).set(index, this.process(value, clazz));
        return this;
    }

    private <X extends Tag<?>> TagList<T> setTag(int index, X value, Class<X> clazz) {
        ((List)this.getValue()).set(index, this.processTag(value, clazz));
        return this;
    }

    public TagList<T> setByte(int index, byte value) {
        return this.set(index, value, TagByte.class);
    }

    public TagList<T> setShort(int index, short value) {
        return this.set(index, value, TagShort.class);
    }

    public TagList<T> setInt(int index, int value) {
        return this.set(index, value, TagInt.class);
    }

    public TagList<T> setLong(int index, long value) {
        return this.set(index, value, TagLong.class);
    }

    public TagList<T> setFloat(int index, float value) {
        return this.set(index, Float.valueOf(value), TagFloat.class);
    }

    public TagList<T> setDouble(int index, double value) {
        return this.set(index, value, TagDouble.class);
    }

    public TagList<T> setByteArray(int index, byte[] value) {
        return this.set(index, value, TagByteArray.class);
    }

    public TagList<T> setIntArray(int index, int[] value) {
        return this.set(index, value, TagIntArray.class);
    }

    public TagList<T> setLongArray(int index, long[] value) {
        return this.set(index, value, TagLongArray.class);
    }

    public TagList<T> setString(int index, String value) {
        return this.set(index, value, TagString.class);
    }

    public TagList<T> setByteTag(int index, TagByte value) {
        return this.setTag(index, value, TagByte.class);
    }

    public TagList<T> setShortTag(int index, TagShort value) {
        return this.setTag(index, value, TagShort.class);
    }

    public TagList<T> setIntTag(int index, TagInt value) {
        return this.setTag(index, value, TagInt.class);
    }

    public TagList<T> setLongTag(int index, TagLong value) {
        return this.setTag(index, value, TagLong.class);
    }

    public TagList<T> setFloatTag(int index, TagFloat value) {
        return this.setTag(index, value, TagFloat.class);
    }

    public TagList<T> setDoubleTag(int index, TagDouble value) {
        return this.setTag(index, value, TagDouble.class);
    }

    public TagList<T> setByteArrayTag(int index, TagByteArray value) {
        return this.setTag(index, value, TagByteArray.class);
    }

    public TagList<T> setIntArrayTag(int index, TagIntArray value) {
        return this.setTag(index, value, TagIntArray.class);
    }

    public TagList<T> setLongArrayTag(int index, TagLongArray value) {
        return this.setTag(index, value, TagLongArray.class);
    }

    public TagList<T> setStringTag(int index, TagString value) {
        return this.setTag(index, value, TagString.class);
    }

    public TagList<T> setCompound(int index, TagCompound value) {
        return this.setTag(index, value, TagCompound.class);
    }

    public TagList<T> setList(int index, TagList<?> value) {
        return this.setTag(index, value, TagList.class);
    }

    public TagList<T> remove(int index) {
        ((List)this.getValue()).remove(index);
        return this;
    }

    public TagList<T> clear() {
        ((List)this.getValue()).clear();
        return this;
    }

    public int size() {
        return ((List)this.getValue()).size();
    }

    public boolean isEmpty() {
        return ((List)this.getValue()).isEmpty();
    }

    private <X extends Tag<?>> TagList<X> cast(Class<X> clazz) {
        this.check(clazz);
        return this;
    }

    public TagList<TagByte> asByteList() {
        return this.cast(TagByte.class);
    }

    public TagList<TagShort> asShortList() {
        return this.cast(TagShort.class);
    }

    public TagList<TagInt> asIntList() {
        return this.cast(TagInt.class);
    }

    public TagList<TagLong> asLongList() {
        return this.cast(TagLong.class);
    }

    public TagList<TagFloat> asFloatList() {
        return this.cast(TagFloat.class);
    }

    public TagList<TagDouble> asDoubleList() {
        return this.cast(TagDouble.class);
    }

    public TagList<TagByteArray> asByteArrayList() {
        return this.cast(TagByteArray.class);
    }

    public TagList<TagIntArray> asIntArrayList() {
        return this.cast(TagIntArray.class);
    }

    public TagList<TagLongArray> asLongArrayList() {
        return this.cast(TagLongArray.class);
    }

    public TagList<TagString> asStringList() {
        return this.cast(TagString.class);
    }

    public TagList<TagCompound> asCompoundList() {
        return this.cast(TagCompound.class);
    }

    public TagList<TagList<?>> asListList() {
        this.check(TagList.class);
        return this;
    }

    public <X extends Tag<?>> TagList<TagList<X>> asListList(Class<X> componentType) {
        this.check(TagList.class);
        for (int i = 0; i < this.size(); ++i) {
            this.getList(i).check(componentType);
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)this.getValue()).iterator();
    }

    public TagType getComponentType() {
        return this.componentType;
    }
}

