/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.tag;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagByte;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagDouble;
import at.syntaxerror.syntaxnbt.tag.TagFloat;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLong;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagShort;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class TagCompound
extends Tag<Map<String, Tag<?>>> {
    public TagCompound() {
        this(Map.of());
    }

    public TagCompound(Map<String, Tag<?>> tags) {
        super(TagType.COMPOUND, new HashMap(tags));
    }

    public boolean has(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return ((Map)this.getValue()).containsKey(key);
    }

    public Tag<?> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!this.has(key)) {
            throw new NBTException("No such element: TAG_Compound[" + SNBTStringifyer.quote(key) + "]");
        }
        return (Tag)((Map)this.getValue()).get(key);
    }

    private <X extends Tag<?>> X get(String key, Class<X> clazz) {
        TagType type = TagType.getTypeFromClass(clazz);
        Tag<?> tag = this.get(key);
        if (!tag.is(type)) {
            throw new NBTException("TAG_Compound[" + SNBTStringifyer.quote(key) + "] is not a " + type);
        }
        return (X)tag;
    }

    public byte getByte(String key) {
        return (Byte)this.getByteTag(key).getValue();
    }

    public short getShort(String key) {
        return (Short)this.getShortTag(key).getValue();
    }

    public int getInt(String key) {
        return (Integer)this.getIntTag(key).getValue();
    }

    public long getLong(String key) {
        return (Long)this.getLongTag(key).getValue();
    }

    public float getFloat(String key) {
        return ((Float)this.getFloatTag(key).getValue()).floatValue();
    }

    public double getDouble(String key) {
        return (Double)this.getDoubleTag(key).getValue();
    }

    public byte[] getByteArray(String key) {
        return (byte[])this.getByteArrayTag(key).getValue();
    }

    public int[] getIntArray(String key) {
        return (int[])this.getIntArrayTag(key).getValue();
    }

    public long[] getLongArray(String key) {
        return (long[])this.getLongArrayTag(key).getValue();
    }

    public String getString(String key) {
        return (String)this.getStringTag(key).getValue();
    }

    public TagByte getByteTag(String key) {
        return this.get(key, TagByte.class);
    }

    public TagShort getShortTag(String key) {
        return this.get(key, TagShort.class);
    }

    public TagInt getIntTag(String key) {
        return this.get(key, TagInt.class);
    }

    public TagLong getLongTag(String key) {
        return this.get(key, TagLong.class);
    }

    public TagFloat getFloatTag(String key) {
        return this.get(key, TagFloat.class);
    }

    public TagDouble getDoubleTag(String key) {
        return this.get(key, TagDouble.class);
    }

    public TagByteArray getByteArrayTag(String key) {
        return this.get(key, TagByteArray.class);
    }

    public TagIntArray getIntArrayTag(String key) {
        return this.get(key, TagIntArray.class);
    }

    public TagLongArray getLongArrayTag(String key) {
        return this.get(key, TagLongArray.class);
    }

    public TagString getStringTag(String key) {
        return this.get(key, TagString.class);
    }

    public TagCompound getCompound(String key) {
        return this.get(key, TagCompound.class);
    }

    public TagList<?> getList(String key) {
        return this.get(key, TagList.class);
    }

    public Tag<?> get(@NonNull String key, Tag<?> defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return ((Map)this.getValue()).getOrDefault(key, defaultValue);
    }

    public TagCompound put(@NonNull String key, @NonNull Tag<?> value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value.is(TagType.END)) {
            throw new NBTException("Cannot add TAG_End to TAG_Compound");
        }
        ((Map)this.getValue()).put(key, value);
        return this;
    }

    private <V, X extends Tag<V>> TagCompound put(String key, V value, Class<X> clazz) {
        try {
            ((Map)this.getValue()).put(key, (Tag)TagType.getTypeFromClass(clazz).getTagClass().getConstructor(value.getClass()).newInstance(value));
            return this;
        }
        catch (NBTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NBTException(e);
        }
    }

    private <X extends Tag<?>> TagCompound putTag(String key, X value) {
        ((Map)this.getValue()).put(key, value);
        return this;
    }

    public TagCompound putByte(String key, byte value) {
        return this.put(key, value, TagByte.class);
    }

    public TagCompound putShort(String key, short value) {
        return this.put(key, value, TagShort.class);
    }

    public TagCompound putInt(String key, int value) {
        return this.put(key, value, TagInt.class);
    }

    public TagCompound putLong(String key, long value) {
        return this.put(key, value, TagLong.class);
    }

    public TagCompound putFloat(String key, float value) {
        return this.put(key, Float.valueOf(value), TagFloat.class);
    }

    public TagCompound putDouble(String key, double value) {
        return this.put(key, value, TagDouble.class);
    }

    public TagCompound putByteArray(String key, byte[] value) {
        return this.put(key, value, TagByteArray.class);
    }

    public TagCompound putIntArray(String key, int[] value) {
        return this.put(key, value, TagIntArray.class);
    }

    public TagCompound putLongArray(String key, long[] value) {
        return this.put(key, value, TagLongArray.class);
    }

    public TagCompound putString(String key, String value) {
        return this.put(key, value, TagString.class);
    }

    public TagCompound putByteTag(String key, TagByte value) {
        return this.putTag(key, value);
    }

    public TagCompound putShortTag(String key, TagShort value) {
        return this.putTag(key, value);
    }

    public TagCompound putIntTag(String key, TagInt value) {
        return this.putTag(key, value);
    }

    public TagCompound putLongTag(String key, TagLong value) {
        return this.putTag(key, value);
    }

    public TagCompound putFloatTag(String key, TagFloat value) {
        return this.putTag(key, value);
    }

    public TagCompound putDoubleTag(String key, TagDouble value) {
        return this.putTag(key, value);
    }

    public TagCompound putByteArrayTag(String key, TagByteArray value) {
        return this.putTag(key, value);
    }

    public TagCompound putIntArrayTag(String key, TagIntArray value) {
        return this.putTag(key, value);
    }

    public TagCompound putLongArrayTag(String key, TagLongArray value) {
        return this.putTag(key, value);
    }

    public TagCompound putStringTag(String key, TagString value) {
        return this.putTag(key, value);
    }

    public TagCompound putCompound(String key, TagCompound value) {
        return this.putTag(key, value);
    }

    public TagCompound putList(String key, TagList<?> value) {
        return this.putTag(key, value);
    }

    public TagCompound remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ((Map)this.getValue()).remove(key);
        return this;
    }

    public int size() {
        return ((Map)this.getValue()).size();
    }

    public boolean isEmpty() {
        return ((Map)this.getValue()).isEmpty();
    }

    public Set<String> keySet() {
        return ((Map)this.getValue()).keySet();
    }

    public TagCompound clear() {
        ((Map)this.getValue()).clear();
        return this;
    }

    public boolean contains(TagCompound other) {
        for (String key : other.keySet()) {
            if (this.has(key) && this.get(key).equals(other.get(key))) continue;
            return false;
        }
        return true;
    }
}

