/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.tag;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagNumber;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.lang.reflect.Array;

public abstract class TagArray<N extends Number, T>
extends Tag<T> {
    private final Class<T> arrayType;

    protected TagArray(TagType type, T array) {
        super(type, array);
        this.arrayType = array.getClass();
        if (!this.arrayType.isArray()) {
            throw new NBTException("Type for array tag must be an array");
        }
    }

    protected void checkBounds(int index) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    protected void checkBoundsExclusive(int index) {
        if (index < 0 || index > this.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public abstract TagArray<N, T> set(int var1, Number var2);

    public TagArray<N, T> setTag(int index, TagNumber<?> value) {
        return this.set(index, (Number)value.getValue());
    }

    public TagArray<N, T> add(Number value) {
        return this.add(this.size(), value);
    }

    public TagArray<N, T> addTag(TagNumber<?> value) {
        return this.addTag(this.size(), value);
    }

    private void expand(int off) {
        this.checkBoundsExclusive(off);
        int sz = this.size();
        Object newArray = Array.newInstance(this.arrayType.getComponentType(), sz + 1);
        System.arraycopy(this.getValue(), 0, newArray, 0, off);
        System.arraycopy(this.getValue(), off, newArray, off + 1, sz - off);
        this.setValue(newArray);
    }

    public TagArray<N, T> add(int index, Number value) {
        this.expand(index);
        return this.set(index, value);
    }

    public TagArray<N, T> addTag(int index, TagNumber<?> value) {
        this.expand(index);
        return this.setTag(index, value);
    }

    public abstract N get(int var1);

    public abstract TagNumber<N> getTag(int var1);

    public int size() {
        return Array.getLength(this.getValue());
    }

    public TagArray<N, T> remove(int index) {
        this.checkBounds(index);
        int sz = this.size();
        Object newArray = Array.newInstance(this.arrayType.getComponentType(), sz - 1);
        System.arraycopy(this.getValue(), 0, newArray, 0, index);
        System.arraycopy(this.getValue(), index + 1, newArray, index, sz - index - 1);
        this.setValue(newArray);
        return this;
    }

    public TagArray<N, T> clear() {
        this.setValue(Array.newInstance(this.arrayType.componentType(), 0));
        return this;
    }

    public Class<T> getArrayType() {
        return this.arrayType;
    }
}

