/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.tag;

import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.util.Objects;
import lombok.NonNull;

public abstract class Tag<T> {
    @NonNull
    private final TagType type;
    @NonNull
    private T value;

    protected Tag(TagType type, T value) {
        this.type = type;
        this.value = value;
    }

    public boolean is(TagType type) {
        return this.type == type;
    }

    public boolean isCompound() {
        return this.is(TagType.COMPOUND);
    }

    public boolean isList() {
        return this.is(TagType.LIST);
    }

    public boolean isList(TagType componentType) {
        return this.isList() && ((TagList)this).getComponentType() == componentType;
    }

    public boolean isArray() {
        return this.is(TagType.BYTE_ARRAY) || this.is(TagType.INT_ARRAY) || this.is(TagType.LONG_ARRAY);
    }

    public boolean isString() {
        return this.is(TagType.STRING);
    }

    public boolean isNumber() {
        return this.isInteger() || this.isFloat();
    }

    public boolean isInteger() {
        return this.is(TagType.BYTE) || this.is(TagType.SHORT) || this.is(TagType.INT) || this.is(TagType.LONG);
    }

    public boolean isFloat() {
        return this.is(TagType.FLOAT) || this.is(TagType.DOUBLE);
    }

    public <N extends Tag<?>> N cast() {
        return (N)this;
    }

    public String toString() {
        return SNBTStringifyer.stringify(this, false);
    }

    protected boolean compare(Tag<T> tag) {
        return Objects.equals(this.getValue(), tag.getValue());
    }

    public boolean equals(Object obj) {
        Tag tag;
        return obj instanceof Tag && (tag = (Tag)obj).getType() == this.getType() && this.compare((Tag<T>)tag.cast());
    }

    @NonNull
    public TagType getType() {
        return this.type;
    }

    @NonNull
    public T getValue() {
        return this.value;
    }

    public void setValue(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

