/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.region;

import at.syntaxerror.syntaxnbt.NBTCompression;
import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.region.Chunk;
import lombok.NonNull;

public class Region {
    @NonNull
    private NBTCompression compression = NBTCompression.ZLIB;
    private int[] timestamps = new int[1024];
    private Chunk[] chunks = new Chunk[1024];

    private int at(int x, int z) {
        if (x < 0 || x > 31 || z < 0 || z > 31) {
            throw new NBTException("Chunk coordinate out of bounds");
        }
        return x * 32 + z;
    }

    public Chunk getChunk(int x, int z) {
        return this.chunks[this.at(x, z)];
    }

    public Region setChunk(int x, int z, Chunk chunk) {
        this.chunks[this.at((int)x, (int)z)] = chunk;
        return this;
    }

    public int getTimestamp(int x, int z) {
        return this.timestamps[this.at(x, z)];
    }

    public Region setTimestamp(int x, int z, int time) {
        this.timestamps[this.at((int)x, (int)z)] = time;
        return this;
    }

    @NonNull
    public NBTCompression getCompression() {
        return this.compression;
    }

    public void setCompression(@NonNull NBTCompression compression) {
        if (compression == null) {
            throw new NullPointerException("compression is marked non-null but is null");
        }
        this.compression = compression;
    }
}

