/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.region;

import at.syntaxerror.syntaxnbt.NBTCompression;
import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.NBTUtil;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

public class Chunk {
    private TagCompound data;
    private byte[] serialized;
    private boolean dirty;
    private NBTCompression compression;

    public Chunk() {
        this.data = new TagCompound();
    }

    public Chunk(TagCompound raw) {
        this.setRaw(raw);
    }

    public Chunk setDirty(boolean dirty) {
        this.dirty = dirty;
        return this;
    }

    public Chunk setCompression(NBTCompression compression) {
        this.compression = compression;
        return this.setDirty(true);
    }

    public Chunk setRaw(TagCompound data) {
        this.data = data;
        return this.setDirty(true);
    }

    @Deprecated
    public byte[] serialize(NBTCompression compression) {
        byte[] byArray;
        if (!this.dirty) {
            return this.serialized;
        }
        compression = Objects.requireNonNullElse(this.compression, compression);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(compression.getId());
            NBTUtil.serialize(null, this.data, out, compression);
            this.serialized = out.toByteArray();
            byArray = this.serialized;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NBTException("Failed to serialize Chunk", e);
            }
        }
        out.close();
        return byArray;
    }

    public TagCompound getData() {
        return this.data;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public NBTCompression getCompression() {
        return this.compression;
    }

    public static enum ChunkStatus {
        EMPTY,
        STRUCTURE_STARTS,
        STRUCTURE_REFERENCES,
        BIOMES,
        NOISE,
        SURFACE,
        CARVERS,
        LIQUID_CARVERS,
        FEATURES,
        LIGHT,
        SPAWN,
        HEIGHTMAPS,
        FULL;

    }
}

