/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.path;

import at.syntaxerror.syntaxnbt.path.PathNode;
import at.syntaxerror.syntaxnbt.path.PathNodeIndex;
import at.syntaxerror.syntaxnbt.path.PathNodeList;
import at.syntaxerror.syntaxnbt.path.PathNodeListTag;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class PathNodeSubList
extends PathNode {
    private final String name;
    private final List<PathNode> indices;

    private @NonNull PathNodeSubList(String name, List<Optional<Integer>> indices) {
        this.name = name;
        this.indices = indices.stream().map(o -> o.map(PathNodeIndex::new)).map(o -> o.orElse(new PathNodeList())).toList();
    }

    public PathNodeSubList(String name, List<Optional<Integer>> indices, TagCompound tag) {
        this(name, indices);
        if (tag != null) {
            this.indices.add(new PathNodeListTag(tag));
        }
    }

    @Override
    public List<Tag<?>> traverseSelf(Tag<?> tag) {
        if (!tag.isCompound()) {
            return List.of();
        }
        TagCompound compound = (TagCompound)tag.cast();
        if (!compound.has(this.name)) {
            return List.of();
        }
        List<Tag<?>> tags = List.of(compound.get(this.name));
        for (PathNode node : this.indices) {
            tags = node.traverseAll(tags);
        }
        return tags;
    }

    @Override
    protected String stringify() {
        return this.indices.stream().map(PathNode::toString).reduce("", String::concat);
    }
}

