/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.path;

import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.path.PathNode;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class PathNodeListTag
extends PathNode {
    private final String name;
    private final TagCompound tag;

    public @NonNull PathNodeListTag(String name, TagCompound tag) {
        this.name = name;
        this.tag = tag;
    }

    protected PathNodeListTag(TagCompound tag) {
        this.name = null;
        this.tag = tag;
    }

    @Override
    public List<Tag<?>> traverseSelf(Tag<?> tag) {
        if (this.name != null && (tag = this.getNamed(this.name, tag)) == null) {
            return List.of();
        }
        if (tag.isList() && ((TagList)tag.cast()).getComponentType() == TagType.COMPOUND) {
            TagList list = (TagList)tag.cast();
            ArrayList result = new ArrayList();
            for (TagCompound compound : list) {
                if (!compound.contains(this.tag)) continue;
                result.add(compound);
            }
            return result;
        }
        return List.of();
    }

    @Override
    protected String stringify() {
        return (this.name == null ? "" : SNBTStringifyer.quote(this.name)) + "[" + this.tag + "]";
    }
}

