/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.path;

import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.path.PathNode;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import java.util.List;

public class PathNodeIndex
extends PathNode {
    private final String name;
    private final int index;

    public PathNodeIndex(String name, int index) {
        this.name = name;
        this.index = index;
    }

    protected PathNodeIndex(int index) {
        this.name = null;
        this.index = index;
    }

    private int checkIndex(int size) {
        int idx = this.index;
        if (idx < 0) {
            idx += size;
        }
        if (idx < 0 || idx >= size) {
            return -1;
        }
        return idx;
    }

    @Override
    public List<Tag<?>> traverseSelf(Tag<?> target) {
        TagArray array;
        int idx;
        if (this.name != null && (target = this.getNamed(this.name, target)) == null) {
            return List.of();
        }
        if (target.isList()) {
            TagList list = (TagList)target.cast();
            int idx2 = this.checkIndex(list.size());
            if (idx2 != -1) {
                return List.of(list.get(idx2));
            }
        } else if (target.isArray() && (idx = this.checkIndex((array = (TagArray)target.cast()).size())) != -1) {
            return List.of(array.getTag(idx));
        }
        return List.of();
    }

    @Override
    protected String stringify() {
        return (this.name == null ? "" : SNBTStringifyer.quote(this.name)) + "[" + this.index + "]";
    }
}

