/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.path;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.path.PathNodeRoot;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import java.util.ArrayList;
import java.util.List;

public abstract class PathNode {
    private PathNode next;

    public void setNext(PathNode next) {
        if (next instanceof PathNodeRoot) {
            throw new NBTException("Cannot specify Root Compound Tag Path Node as child");
        }
        this.next = next;
    }

    protected abstract List<Tag<?>> traverseSelf(Tag<?> var1);

    public final List<Tag<?>> traverse(Tag<?> tag) {
        List<Tag<?>> tags = this.traverseSelf(tag);
        return this.next == null ? tags : this.next.traverseAll(tags);
    }

    public final List<Tag<?>> traverseAll(List<Tag<?>> tags) {
        ArrayList result = new ArrayList();
        for (Tag<?> tag : tags) {
            result.addAll(this.traverse(tag));
        }
        return result;
    }

    protected Tag<?> getNamed(String name, Tag<?> tag) {
        if (!tag.isCompound()) {
            return null;
        }
        TagCompound compound = (TagCompound)tag.cast();
        if (!compound.has(name)) {
            return null;
        }
        return compound.get(name);
    }

    protected abstract String stringify();

    public String toString() {
        return this.stringify() + (String)(this.next == null ? "" : "." + this.next.toString());
    }

    public PathNode getNext() {
        return this.next;
    }
}

