/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.NBTUtil;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagArray;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagNumber;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;

public class SNBTStringifyer {
    private static final String NO_QUOTE = "^[a-zA-Z0-9_.+-]+$";
    private static final SNBTStringifyer PLAIN = new SNBTStringifyer("", "", "", "", "");
    private static final SNBTStringifyer COLORFUL = new SNBTStringifyer("\u00a7f", "\u00a7a", "\u00a7b", "\u00a76", "\u00a7c");
    private final String colorPunctuator;
    private final String colorString;
    private final String colorIdentifier;
    private final String colorNumber;
    private final String colorSuffix;
    private final String quote;
    private final String comma;

    private SNBTStringifyer(String punct, String string, String ident, String number, String suffix) {
        this.colorPunctuator = punct;
        this.colorString = string;
        this.colorIdentifier = ident;
        this.colorNumber = number;
        this.colorSuffix = suffix;
        this.quote = this.colorPunctuator + "\"";
        this.comma = this.colorPunctuator + ", ";
    }

    private String process(Tag<?> tag, int depth) {
        if (tag instanceof TagCompound) {
            TagCompound compound = (TagCompound)tag;
            return this.processCompound(compound, depth);
        }
        if (tag instanceof TagList) {
            TagList list = (TagList)tag;
            return this.processList(list, depth);
        }
        if (tag instanceof TagByteArray) {
            TagByteArray array = (TagByteArray)tag;
            return this.processArray(array, "B", "B");
        }
        if (tag instanceof TagIntArray) {
            TagIntArray array = (TagIntArray)tag;
            return this.processArray(array, "I", null);
        }
        if (tag instanceof TagLongArray) {
            TagLongArray array = (TagLongArray)tag;
            return this.processArray(array, "L", "L");
        }
        if (tag instanceof TagString) {
            TagString string = (TagString)tag;
            return this.quote + this.colorString + SNBTStringifyer.quoteSoft((String)string.getValue()) + this.quote;
        }
        if (tag instanceof TagNumber) {
            TagNumber number = (TagNumber)tag;
            StringBuilder sb = new StringBuilder();
            sb.append(this.colorNumber).append(number.getValue());
            if (number.getType() != TagType.INT) {
                StringBuilder stringBuilder = sb.append(this.colorSuffix);
                stringBuilder.append(switch (number.getType()) {
                    case TagType.BYTE -> 'b';
                    case TagType.SHORT -> 's';
                    case TagType.LONG -> 'l';
                    case TagType.FLOAT -> 'f';
                    case TagType.DOUBLE -> 'd';
                    default -> throw new NBTException("Tag is not stringifyable: " + tag.getType());
                });
            }
            return sb.toString();
        }
        throw new NBTException("Tag is not stringifyable: " + tag.getType());
    }

    private String processCompound(TagCompound compound, int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.colorPunctuator).append('{');
        int i = 0;
        if (depth-- > 0) {
            for (String key : compound.keySet()) {
                if (i++ > 0) {
                    sb.append(this.comma);
                }
                if (key.matches(NO_QUOTE)) {
                    sb.append(this.colorIdentifier).append(key);
                } else {
                    sb.append(this.quote).append(this.colorIdentifier).append(SNBTStringifyer.quoteSoft(key)).append(this.quote);
                }
                sb.append(this.colorPunctuator).append(": ").append(this.process(compound.get(key), depth));
            }
        }
        sb.append(this.colorPunctuator).append('}');
        return sb.toString();
    }

    private String processList(TagList<?> list, int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.colorPunctuator).append('[');
        if (depth-- > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    sb.append(this.comma);
                }
                sb.append(this.process((Tag<?>)list.get(i), depth));
            }
        }
        sb.append(this.colorPunctuator).append(']');
        return sb.toString();
    }

    private String processArray(TagArray<?, ?> array, String prefix, String suffix) {
        prefix = this.colorSuffix + (String)prefix;
        suffix = suffix == null ? "" : this.colorSuffix + (String)suffix;
        StringBuilder sb = new StringBuilder();
        sb.append(this.colorPunctuator).append('[').append((String)prefix).append(this.colorPunctuator).append(';');
        if (array.size() != 0) {
            sb.append(' ');
        }
        for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                sb.append(this.comma);
            }
            sb.append(this.colorNumber).append(array.get(i)).append((String)suffix);
        }
        sb.append(this.colorPunctuator).append(']');
        return sb.toString();
    }

    public static String stringify(Tag<?> tag, boolean colored) {
        return (colored ? COLORFUL : PLAIN).process(tag, NBTUtil.MAX_DEPTH);
    }

    private static String quoteSoft(String string) {
        StringBuilder sb = new StringBuilder();
        block5: for (char c : string.toCharArray()) {
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String quote(String string) {
        if (string.matches(NO_QUOTE) && !string.isEmpty()) {
            return string;
        }
        return "\"" + SNBTStringifyer.quoteSoft(string) + "\"";
    }
}

