/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagArray;
import at.syntaxerror.syntaxnbt.tag.TagByte;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagDouble;
import at.syntaxerror.syntaxnbt.tag.TagFloat;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLong;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagNumber;
import at.syntaxerror.syntaxnbt.tag.TagShort;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SNBTParser {
    private static final Pattern PATTERN_BOOLEAN = Pattern.compile("true|false", 2);
    protected static final Pattern PATTERN_INTEGER = Pattern.compile("([+-]?(?:0|[1-9]\\d*))([bsl]?)", 2);
    private static final Pattern PATTERN_FLOAT_INTEGER = Pattern.compile("([+-]?\\d+)([fd])", 2);
    private static final Pattern PATTERN_FLOAT_INTEGER_EXP = Pattern.compile("([+-]?\\d+e[+-]?\\d+)([fd]?)", 2);
    private static final Pattern PATTERN_FLOAT_DECIMAL = Pattern.compile("([+-]?(?:(?:0|[1-9]\\d*)?\\.\\d*)(?:e[+-]?\\d+)?)([df]?)", 2);
    private static final Pattern[] PATTERNS_FLOAT = new Pattern[]{PATTERN_FLOAT_INTEGER, PATTERN_FLOAT_INTEGER_EXP, PATTERN_FLOAT_DECIMAL};
    private static final Map<String, Function<BigDecimal, Tag<?>>> FLOAT_CONVERTERS = Map.of("f", v -> new TagFloat(Float.valueOf(v.floatValue())), "d", v -> new TagDouble(v.doubleValue()));
    protected static final Map<String, Range> INTEGER_BOUNDS = Map.of("b", new Range(BigInteger.valueOf(-128L), BigInteger.valueOf(127L), v -> new TagByte(v.byteValue())), "s", new Range(BigInteger.valueOf(-32768L), BigInteger.valueOf(32767L), v -> new TagShort(v.shortValue())), "", new Range(BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Integer.MAX_VALUE), v -> new TagInt(v.intValue())), "l", new Range(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE), v -> new TagLong(v.longValue())));
    private Reader reader;
    private boolean eof;
    private boolean back;
    private long index;
    private char current;
    private StringBuilder cache;

    SNBTParser(Reader reader) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.eof = false;
        this.back = false;
        this.index = -1L;
        this.current = '\u0000';
        this.cache = new StringBuilder();
    }

    protected boolean more() {
        if (this.back || this.eof) {
            return this.back && !this.eof;
        }
        return this.peek() > '\u0000';
    }

    protected void back() {
        this.back = true;
    }

    protected char peek() {
        int c;
        if (this.eof) {
            return '\u0000';
        }
        try {
            this.reader.mark(1);
            c = this.reader.read();
            this.reader.reset();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not peek from source", e);
        }
        return c == -1 ? (char)'\u0000' : (char)c;
    }

    protected char next() {
        int c;
        if (this.back) {
            this.back = false;
            return this.current;
        }
        try {
            c = this.reader.read();
            this.cache.append((char)c);
        }
        catch (Exception e) {
            throw this.syntaxError("Could not read from source", e);
        }
        if (c < 0) {
            this.eof = true;
            return '\u0000';
        }
        this.current = (char)c;
        ++this.index;
        return this.current;
    }

    protected char nextClean() {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        return c;
    }

    protected String nextString(boolean alt) {
        Predicate<Character> isValuePart;
        char c = this.nextClean();
        StringBuilder sb = new StringBuilder();
        if (c == '\"' || c == '\'') {
            char delim = c;
            block3: while (true) {
                if (!this.more()) {
                    throw this.syntaxError("Unexpected end of data");
                }
                c = this.next();
                if (c == delim) break;
                if (c == '\r' || c == '\n') {
                    throw this.syntaxError("Illegal line terminator in string");
                }
                if (c == '\\') {
                    c = this.next();
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            sb.append(c);
                            continue block3;
                        }
                    }
                    throw this.syntaxError("Illegal escape sequence '\\" + c + "'");
                }
                sb.append(c);
            }
            return sb.toString();
        }
        Predicate<Character> predicate = isValuePart = alt ? this::isValuePartAlt : SNBTParser::isValuePart;
        if (!isValuePart.test(Character.valueOf(c))) {
            throw this.syntaxError("Expected string");
        }
        this.back();
        while (this.more()) {
            c = this.next();
            if (!isValuePart.test(Character.valueOf(c))) {
                this.back();
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected TagCompound nextCompound() {
        if (this.nextClean() != '{') {
            throw this.syntaxError("'{' expected in TAG_Compound");
        }
        TagCompound compound = new TagCompound();
        char c = this.nextClean();
        while (c != '}') {
            this.back();
            String key = this.nextString(false);
            if (compound.has(key)) {
                throw this.syntaxError("Duplicate key " + SNBTStringifyer.quote(key) + " in TAG_Compound");
            }
            c = this.nextClean();
            if (c != ':') {
                throw this.syntaxError("':' expected in TAG_Compound");
            }
            compound.put(key, this.nextTag());
            c = this.nextClean();
            if (c == ',') {
                c = this.nextClean();
                continue;
            }
            if (c == '}') break;
            throw this.syntaxError("'}' expected in TAG_Compound");
        }
        return compound;
    }

    private <T extends Tag<?>> void processList(T list, TagType expectation, Consumer<Tag<?>> consumer) {
        char c = this.nextClean();
        while (c != ']') {
            this.back();
            Tag<?> tag = this.nextTag();
            if (!tag.is(expectation)) {
                throw this.syntaxError("Expected " + expectation + " in " + list.getType());
            }
            consumer.accept(tag);
            c = this.nextClean();
            if (c == ',') {
                c = this.nextClean();
                continue;
            }
            if (c == ']') break;
            throw this.syntaxError("']' expected in " + list.getType());
        }
    }

    private Tag<?> nextList() {
        char c = this.next();
        if (c == 'B' || c == 'I' || c == 'L') {
            if (this.peek() == ';') {
                TagArray array;
                TagType type;
                switch (c) {
                    case 'B': {
                        type = TagType.BYTE;
                        array = new TagByteArray();
                        break;
                    }
                    case 'I': {
                        type = TagType.INT;
                        array = new TagIntArray();
                        break;
                    }
                    case 'L': {
                        type = TagType.LONG;
                        array = new TagLongArray();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                this.next();
                this.processList(array, type, tag -> array.addTag((TagNumber)tag));
                return array;
            }
            this.back();
        }
        if ((c = this.nextClean()) == ']') {
            return TagList.emptyList();
        }
        this.back();
        Tag<?> first = this.nextTag();
        TagList<Tag<?>> list = TagList.emptyList();
        list.add(first);
        c = this.nextClean();
        if (c == ',') {
            this.processList(list, list.getComponentType(), list::add);
        } else if (c != ']') {
            throw this.syntaxError("']' expected in " + list.getType());
        }
        return list;
    }

    private Tag<?> nextTag() {
        char c = this.nextClean();
        if (c == '[') {
            return this.nextList();
        }
        if (c == '{') {
            this.back();
            return this.nextCompound();
        }
        if (c == '\"' || c == '\'') {
            this.back();
            return new TagString(this.nextString(false));
        }
        if (!SNBTParser.isValuePart(c)) {
            throw this.syntaxError("Value expected");
        }
        this.back();
        String str = this.nextString(false);
        Matcher matcher = PATTERN_BOOLEAN.matcher(str);
        if (matcher.matches()) {
            return new TagByte(str.equalsIgnoreCase("true"));
        }
        matcher = PATTERN_INTEGER.matcher(str);
        if (matcher.matches()) {
            BigInteger val;
            Range range = INTEGER_BOUNDS.get(matcher.group(2).toLowerCase());
            if (range.inRange(val = new BigInteger(matcher.group(1)))) {
                return range.convert(val);
            }
            return new TagString(str);
        }
        boolean success = false;
        for (Pattern pattern : PATTERNS_FLOAT) {
            matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            success = true;
            break;
        }
        if (!success) {
            return new TagString(str);
        }
        String suffix = matcher.group(2).toLowerCase();
        if (suffix.isEmpty()) {
            suffix = "d";
        }
        return FLOAT_CONVERTERS.get(suffix).apply(new BigDecimal(matcher.group(1)));
    }

    protected boolean isValuePartAlt(char c) {
        return false;
    }

    protected static boolean isValuePart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '+' || c == '-';
    }

    public static TagCompound parse(String input) {
        try (StringReader sr = new StringReader(input.strip());){
            SNBTParser parser = new SNBTParser(sr);
            TagCompound tag = parser.nextCompound();
            if (parser.more()) {
                throw parser.syntaxError("Trailing data");
            }
            TagCompound tagCompound = tag;
            return tagCompound;
        }
    }

    private NBTException syntaxError(String message, Throwable cause) {
        return new NBTException(message + this, cause);
    }

    protected NBTException syntaxError(String message) {
        return this.syntaxError(message, null);
    }

    public String toString() {
        Object highlight = this.cache.toString();
        if (((String)highlight).length() > 10) {
            highlight = "..." + ((String)highlight).substring(((String)highlight).length() - 10);
        }
        if (this.back) {
            highlight = ((String)highlight).substring(0, ((String)highlight).length() - 1);
        }
        return " at position " + this.index + ": \u00bb" + (String)highlight + "\u00ab";
    }

    protected record Range(BigInteger min, BigInteger max, Function<BigInteger, Tag<?>> converter) {
        protected boolean inRange(BigInteger number) {
            return number.compareTo(this.min) >= 0 && number.compareTo(this.max) <= 0;
        }

        protected Tag<?> convert(BigInteger number) {
            return this.converter().apply(number);
        }
    }
}

