/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTCompression;
import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.NBTUtil;
import at.syntaxerror.syntaxnbt.region.Chunk;
import at.syntaxerror.syntaxnbt.region.Region;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RegionUtil {
    public static void serialize(Region region, RandomAccessFile output) throws IOException {
        try (ByteArrayOutputStream locationBytes = new ByteArrayOutputStream();
             ByteArrayOutputStream timestampBytes = new ByteArrayOutputStream();
             DataOutputStream locationStream = new DataOutputStream(locationBytes);
             DataOutputStream timestampStream = new DataOutputStream(timestampBytes);){
            int offset = 2;
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    Chunk chunk = region.getChunk(x, z);
                    if (chunk == null) {
                        locationStream.writeInt(0);
                        timestampStream.writeInt(0);
                        continue;
                    }
                    byte[] buf = chunk.serialize(region.getCompression());
                    int size = buf.length / 4096 + (buf.length % 4096 == 0 ? 0 : 1);
                    if (size != (size & 0xFF)) {
                        throw new NBTException("Chunk is too big (>1MiB)");
                    }
                    locationStream.writeInt(offset << 8 | size);
                    timestampStream.writeInt(region.getTimestamp(x, z));
                    output.seek(offset * 4096);
                    output.write(buf);
                    offset += size;
                }
            }
            output.seek(0L);
            output.write(locationBytes.toByteArray());
            if (output.getFilePointer() != 4096L) {
                throw new NBTException("Location header size mismatch");
            }
            output.write(timestampBytes.toByteArray());
            if (output.getFilePointer() != 8192L) {
                throw new NBTException("Timestamp header size mismatch");
            }
        }
    }

    public static Region deserialize(RandomAccessFile input) throws IOException {
        Region region = new Region();
        byte[] locationBytes = new byte[4096];
        byte[] timestampBytes = new byte[4096];
        input.read(locationBytes);
        input.read(timestampBytes);
        try (DataInputStream locationStream = new DataInputStream(new ByteArrayInputStream(locationBytes));
             DataInputStream timestampStream = new DataInputStream(new ByteArrayInputStream(timestampBytes));){
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    int location = locationStream.readInt();
                    int timestamp = timestampStream.readInt();
                    region.setTimestamp(x, z, timestamp);
                    if (location == 0) continue;
                    input.seek((long)(location >> 8 & 0xFFFFFF) * 4096L);
                    byte[] buf = new byte[input.readInt()];
                    input.read(buf);
                    try (InputStream in = NBTCompression.ZLIB.newInputStream(new ByteArrayInputStream(buf, 1, buf.length - 1));
                         FileOutputStream fos = new FileOutputStream("/run/media/thomas/Shared/Git/syntaxnbt/src/test/test.mcr");){
                        in.transferTo(fos);
                    }
                    try (ByteArrayInputStream buffer = new ByteArrayInputStream(buf);){
                        NBTCompression compression = NBTCompression.getCompressionFromId((byte)buffer.read());
                        Chunk chunk = new Chunk(NBTUtil.deserialize(buffer, compression).getCompound(""));
                        chunk.setCompression(compression);
                        region.setChunk(x, z, chunk);
                        continue;
                    }
                }
            }
        }
        return region;
    }

    private RegionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

