/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.internal.SNBTParser;
import at.syntaxerror.syntaxnbt.path.PathNode;
import at.syntaxerror.syntaxnbt.path.PathNodeCompound;
import at.syntaxerror.syntaxnbt.path.PathNodeIndex;
import at.syntaxerror.syntaxnbt.path.PathNodeList;
import at.syntaxerror.syntaxnbt.path.PathNodeListTag;
import at.syntaxerror.syntaxnbt.path.PathNodeNamed;
import at.syntaxerror.syntaxnbt.path.PathNodeRoot;
import at.syntaxerror.syntaxnbt.path.PathNodeSubList;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathParser
extends SNBTParser {
    private static final Pattern PATTERN_INT = Pattern.compile("([+-]?(?:0|[1-9]\\d*))");
    private static final SNBTParser.Range RANGE_INT = new SNBTParser.Range(BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Integer.MAX_VALUE), v -> new TagInt(v.intValue()));

    private PathParser(Reader reader) {
        super(reader);
    }

    private PathNode nextPath() {
        PathNode node;
        char c = this.next();
        this.back();
        if (c == '{') {
            node = new PathNodeRoot(this.nextCompound());
        } else {
            String name = this.nextString(true);
            char c2 = c = this.more() ? this.next() : (char)'\u0000';
            if (c == '{') {
                this.back();
                node = new PathNodeCompound(name, this.nextCompound());
            } else if (c == '[') {
                c = this.next();
                boolean checkSub = true;
                Optional<Object> index = Optional.empty();
                if (c == ']') {
                    node = new PathNodeList(name);
                } else if (c == '{') {
                    this.back();
                    checkSub = false;
                    node = new PathNodeListTag(name, this.nextCompound());
                    this.expect(']');
                } else {
                    this.back();
                    int idx = this.nextInt();
                    this.expect(']');
                    node = new PathNodeIndex(name, idx);
                    index = Optional.of(idx);
                }
                if (checkSub && this.peek() == '[') {
                    ArrayList<Optional<Integer>> indices = new ArrayList<Optional<Integer>>();
                    TagCompound tag = null;
                    boolean valid = index.isPresent();
                    indices.add(index);
                    while (this.more()) {
                        c = this.next();
                        if (c != '[') {
                            if (!valid) {
                                throw this.syntaxError("Expected Integer or Compound Tag");
                            }
                            this.back();
                            break;
                        }
                        c = this.next();
                        if (c == '{') {
                            this.back();
                            tag = this.nextCompound();
                            this.expect(']');
                            break;
                        }
                        if (c == ']') {
                            valid = false;
                            indices.add(Optional.empty());
                            continue;
                        }
                        this.back();
                        valid = true;
                        indices.add(Optional.of(this.nextInt()));
                        this.expect(']');
                    }
                    node = new PathNodeSubList(name, indices, tag);
                }
            } else {
                if (c != '\u0000') {
                    this.back();
                }
                node = new PathNodeNamed(name);
            }
        }
        if (!this.more()) {
            return node;
        }
        this.expect('.');
        node.setNext(this.nextPath());
        return node;
    }

    private void expect(char c) {
        if (this.next() != c) {
            throw this.syntaxError("'" + c + "' expected");
        }
    }

    private int nextInt() {
        String str = this.nextString(false);
        Matcher matcher = PATTERN_INT.matcher(str);
        if (!matcher.matches()) {
            throw this.syntaxError("Expected Integer");
        }
        BigInteger val = new BigInteger(matcher.group(1));
        if (!RANGE_INT.inRange(val)) {
            throw this.syntaxError("Index is too big");
        }
        return val.intValue();
    }

    @Override
    protected boolean isValuePartAlt(char c) {
        return c != '[' && c != '{' && c != '.' && !Character.isWhitespace(c);
    }

    public static PathNode parsePath(String input) {
        try (StringReader sr = new StringReader(input.strip());){
            PathParser parser = new PathParser(sr);
            PathNode path = parser.nextPath();
            if (parser.more()) {
                throw parser.syntaxError("Trailing data");
            }
            PathNode pathNode = path;
            return pathNode;
        }
    }
}

