/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.NBTUtil;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagArray;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagNumber;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.io.DataOutputStream;
import java.io.IOException;

public class NBTSerializer {
    private static void serializeCompound(TagCompound compound, DataOutputStream output, int depth) throws IOException {
        if (depth-- > 0) {
            for (String key : compound.keySet()) {
                Tag<?> value = compound.get(key);
                output.writeByte(value.getType().getId());
                output.writeUTF(key);
                NBTSerializer.serialize(value, output, depth);
            }
        }
        output.writeByte(TagType.END.getId());
    }

    private static void serializeList(TagList<?> list, DataOutputStream output, int depth) throws IOException {
        int sz = depth-- > 0 ? list.size() : 0;
        TagType type = list.getComponentType();
        if (type == null || type == TagType.END) {
            output.writeByte(TagType.END.getId());
            output.writeInt(0);
            return;
        }
        output.writeByte(type.getId());
        output.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            NBTSerializer.serialize(list.get(i), output, depth);
        }
    }

    private static <N extends Number> void serializeArray(TagArray<N, ?> array, DataOutputStream output, ArraySerializer<N> serializer) throws IOException {
        int sz = array.size();
        output.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            serializer.serialize(array.get(i));
        }
    }

    private static void serialize(Tag<?> tag, DataOutputStream output, int depth) throws IOException {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (!(tag instanceof TagCompound)) break block8;
                                        TagCompound compound = (TagCompound)tag;
                                        NBTSerializer.serializeCompound(compound, output, depth);
                                        break block9;
                                    }
                                    if (!(tag instanceof TagList)) break block10;
                                    TagList list = (TagList)tag;
                                    NBTSerializer.serializeList(list, output, depth);
                                    break block9;
                                }
                                if (!(tag instanceof TagByteArray)) break block11;
                                TagByteArray array = (TagByteArray)tag;
                                NBTSerializer.serializeArray(array, output, v -> output.writeByte(v.byteValue()));
                                break block9;
                            }
                            if (!(tag instanceof TagIntArray)) break block12;
                            TagIntArray array = (TagIntArray)tag;
                            NBTSerializer.serializeArray(array, output, output::writeInt);
                            break block9;
                        }
                        if (!(tag instanceof TagLongArray)) break block13;
                        TagLongArray array = (TagLongArray)tag;
                        NBTSerializer.serializeArray(array, output, output::writeLong);
                        break block9;
                    }
                    if (!(tag instanceof TagString)) break block14;
                    TagString string = (TagString)tag;
                    output.writeUTF((String)string.getValue());
                    break block9;
                }
                if (!(tag instanceof TagNumber)) break block15;
                TagNumber number = (TagNumber)tag;
                switch (number.getType()) {
                    case BYTE: {
                        output.writeByte(number.byteValue());
                        break block9;
                    }
                    case SHORT: {
                        output.writeShort(number.shortValue());
                        break block9;
                    }
                    case INT: {
                        output.writeInt(number.intValue());
                        break block9;
                    }
                    case LONG: {
                        output.writeLong(number.longValue());
                        break block9;
                    }
                    case FLOAT: {
                        output.writeFloat(number.floatValue());
                        break block9;
                    }
                    case DOUBLE: {
                        output.writeDouble(number.doubleValue());
                        break block9;
                    }
                    default: {
                        throw new NBTException("Tag is not serializable: " + tag);
                    }
                }
            }
            throw new NBTException("Tag is not serializable: " + tag);
        }
    }

    public static void serialize(String name, TagCompound compound, DataOutputStream output) throws IOException {
        if (name == null) {
            name = "";
        }
        NBTSerializer.serialize(new TagCompound().put(name, compound), output, NBTUtil.MAX_DEPTH);
    }

    private static interface ArraySerializer<N extends Number> {
        public void serialize(N var1) throws IOException;
    }
}

