/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTException;
import at.syntaxerror.syntaxnbt.tag.Tag;
import at.syntaxerror.syntaxnbt.tag.TagArray;
import at.syntaxerror.syntaxnbt.tag.TagByte;
import at.syntaxerror.syntaxnbt.tag.TagByteArray;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import at.syntaxerror.syntaxnbt.tag.TagDouble;
import at.syntaxerror.syntaxnbt.tag.TagFloat;
import at.syntaxerror.syntaxnbt.tag.TagInt;
import at.syntaxerror.syntaxnbt.tag.TagIntArray;
import at.syntaxerror.syntaxnbt.tag.TagList;
import at.syntaxerror.syntaxnbt.tag.TagLong;
import at.syntaxerror.syntaxnbt.tag.TagLongArray;
import at.syntaxerror.syntaxnbt.tag.TagNumber;
import at.syntaxerror.syntaxnbt.tag.TagShort;
import at.syntaxerror.syntaxnbt.tag.TagString;
import at.syntaxerror.syntaxnbt.tag.TagType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class NBTDeserializer {
    private static void deserializeCompound(TagCompound compound, DataInputStream input) throws IOException {
        TagType type;
        HashMap tags = new HashMap();
        while ((type = TagType.getTypeFromId(input.readByte())) != TagType.END) {
            String key = input.readUTF();
            tags.put(key, NBTDeserializer.deserializeNew(type, input));
        }
        compound.setValue(tags);
    }

    private static void deserializeList(TagList<?> list, DataInputStream input) throws IOException {
        int sz = input.readInt();
        ArrayList tags = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            tags.add(NBTDeserializer.deserializeNew(list.getComponentType(), input));
        }
        list.setValue(tags);
    }

    private static <N extends Number> void deserializeArray(TagArray<N, ?> array, DataInputStream input, ArrayDeserializer<N> deserializer) throws IOException {
        int sz = input.readInt();
        array.clear();
        for (int i = 0; i < sz; ++i) {
            array.add((Number)deserializer.deserialize());
        }
    }

    private static Tag<?> deserializeNew(TagType type, DataInputStream input) throws IOException {
        Tag tag;
        if (type == TagType.LIST) {
            type = TagType.getTypeFromId(input.readByte());
            if (type == TagType.END) {
                input.readInt();
                return TagList.emptyList();
            }
            try {
                tag = (Tag)TagType.LIST.getTagClass().getConstructor(Class.class).newInstance(type.getTagClass());
            }
            catch (Exception e) {
                throw new NBTException("Failed to instantiate TAG_List", e);
            }
        }
        try {
            tag = (Tag)type.getTagClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new NBTException("Failed to instantiate " + type, e);
        }
        NBTDeserializer.deserializeTag(tag, input);
        return tag;
    }

    private static <T extends Tag<?>> T deserializeTag(T tag, DataInputStream input) throws IOException {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (!(tag instanceof TagCompound)) break block8;
                                        TagCompound compound = (TagCompound)tag;
                                        NBTDeserializer.deserializeCompound(compound, input);
                                        break block9;
                                    }
                                    if (!(tag instanceof TagList)) break block10;
                                    TagList list = (TagList)tag;
                                    NBTDeserializer.deserializeList(list, input);
                                    break block9;
                                }
                                if (!(tag instanceof TagByteArray)) break block11;
                                TagByteArray array = (TagByteArray)tag;
                                NBTDeserializer.deserializeArray(array, input, input::readByte);
                                break block9;
                            }
                            if (!(tag instanceof TagIntArray)) break block12;
                            TagIntArray array = (TagIntArray)tag;
                            NBTDeserializer.deserializeArray(array, input, input::readInt);
                            break block9;
                        }
                        if (!(tag instanceof TagLongArray)) break block13;
                        TagLongArray array = (TagLongArray)tag;
                        NBTDeserializer.deserializeArray(array, input, input::readLong);
                        break block9;
                    }
                    if (!(tag instanceof TagString)) break block14;
                    TagString string = (TagString)tag;
                    string.setValue(input.readUTF());
                    break block9;
                }
                if (!(tag instanceof TagNumber)) break block15;
                TagNumber number = (TagNumber)tag;
                switch (number.getType()) {
                    case BYTE: {
                        ((TagByte)number).setValue(input.readByte());
                        break block9;
                    }
                    case SHORT: {
                        ((TagShort)number).setValue(input.readShort());
                        break block9;
                    }
                    case INT: {
                        ((TagInt)number).setValue(input.readInt());
                        break block9;
                    }
                    case LONG: {
                        ((TagLong)number).setValue(input.readLong());
                        break block9;
                    }
                    case FLOAT: {
                        ((TagFloat)number).setValue(Float.valueOf(input.readFloat()));
                        break block9;
                    }
                    case DOUBLE: {
                        ((TagDouble)number).setValue(input.readDouble());
                        break block9;
                    }
                    default: {
                        throw new NBTException("Tag is not deserializable: " + tag);
                    }
                }
            }
            throw new NBTException("Tag is not deserializable: " + tag);
        }
        return tag;
    }

    public static TagCompound deserialize(TagCompound tag, DataInputStream input) throws IOException {
        if (input.readByte() != TagType.COMPOUND.getId()) {
            throw new NBTException("Invalid ID for TAG_Compound");
        }
        String name = input.readUTF();
        tag.putCompound(name, NBTDeserializer.deserializeTag(new TagCompound(), input));
        return tag;
    }

    private static interface ArrayDeserializer<N extends Number> {
        public N deserialize() throws IOException;
    }
}

