/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt.internal;

import at.syntaxerror.syntaxnbt.NBTCompression;
import java.io.IOException;
import java.io.InputStream;

public final class NBTCompressionUtil {
    public static NBTCompression findCompression(InputStream stream) throws IOException {
        stream.mark(2);
        byte[] header = new byte[2];
        NBTCompression compression = NBTCompression.NONE;
        if (stream.read(header) == 2) {
            int msb = header[0] & 0xFF;
            int magic = msb << 8 | header[1] & 0xFF;
            if (magic == 8075) {
                compression = NBTCompression.GZIP;
            } else if (msb == 120 && magic % 31 == 0) {
                compression = NBTCompression.ZLIB;
            }
        }
        stream.reset();
        return compression;
    }

    private NBTCompressionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

