/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt;

import at.syntaxerror.syntaxnbt.NBTCompression;
import at.syntaxerror.syntaxnbt.internal.NBTCompressionUtil;
import at.syntaxerror.syntaxnbt.internal.NBTDeserializer;
import at.syntaxerror.syntaxnbt.internal.NBTSerializer;
import at.syntaxerror.syntaxnbt.internal.PathParser;
import at.syntaxerror.syntaxnbt.internal.RegionUtil;
import at.syntaxerror.syntaxnbt.internal.SNBTParser;
import at.syntaxerror.syntaxnbt.internal.SNBTStringifyer;
import at.syntaxerror.syntaxnbt.path.PathNode;
import at.syntaxerror.syntaxnbt.region.Region;
import at.syntaxerror.syntaxnbt.tag.TagCompound;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class NBTUtil {
    public static int MAX_DEPTH = 512;

    public static TagCompound deserialize(InputStream input) throws IOException {
        return NBTUtil.deserialize(input, NBTCompressionUtil.findCompression(input));
    }

    public static TagCompound deserialize(InputStream input, NBTCompression compression) throws IOException {
        try (InputStream decompressed = compression.newInputStream(input);){
            TagCompound tagCompound;
            try (DataInputStream in = new DataInputStream(decompressed);){
                tagCompound = NBTDeserializer.deserialize(new TagCompound(), in);
            }
            return tagCompound;
        }
    }

    public static Region deserializeRegion(RandomAccessFile input) throws IOException {
        return RegionUtil.deserialize(input);
    }

    public static void serialize(String name, TagCompound compound, OutputStream output) throws IOException {
        NBTUtil.serialize(name, compound, output, NBTCompression.NONE);
    }

    public static void serialize(String name, TagCompound compound, OutputStream output, NBTCompression compression) throws IOException {
        try (OutputStream compressed = compression.newOutputStream(output);
             DataOutputStream out = new DataOutputStream(compressed);){
            NBTSerializer.serialize(name, compound, out);
        }
    }

    public static void serializeRegion(Region region, RandomAccessFile output) throws IOException {
        RegionUtil.serialize(region, output);
    }

    public static TagCompound parse(String input) {
        return SNBTParser.parse(input);
    }

    public static PathNode parsePath(String input) {
        return PathParser.parsePath(input);
    }

    public static String stringify(TagCompound compound) {
        return NBTUtil.stringify(compound, false);
    }

    public static String stringify(TagCompound compound, boolean colored) {
        return SNBTStringifyer.stringify(compound, colored);
    }

    public static String stringify(PathNode path) {
        return path.toString();
    }

    private NBTUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

