/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.syntaxnbt;

import at.syntaxerror.syntaxnbt.NBTException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public enum NBTCompression {
    GZIP(1, GZIPOutputStream::new, GZIPInputStream::new),
    ZLIB(2, DeflaterOutputStream::new, InflaterInputStream::new),
    NONE(3, stream -> stream, stream -> stream);

    private static final Map<Byte, NBTCompression> MAPPING;
    private final byte id;
    private final StreamFactory<OutputStream> outputStreamFactory;
    private final StreamFactory<InputStream> inputStreamFactory;

    public static NBTCompression getCompressionFromId(byte id) {
        if (!MAPPING.containsKey(id)) {
            throw new NBTException("Unrecognized compression scheme: " + id);
        }
        return MAPPING.get(id);
    }

    public OutputStream newOutputStream(OutputStream stream) throws IOException {
        return this.outputStreamFactory.construct(stream);
    }

    public InputStream newInputStream(InputStream stream) throws IOException {
        return this.inputStreamFactory.construct(stream);
    }

    private NBTCompression(byte id, StreamFactory<OutputStream> outputStreamFactory, StreamFactory<InputStream> inputStreamFactory) {
        this.id = id;
        this.outputStreamFactory = outputStreamFactory;
        this.inputStreamFactory = inputStreamFactory;
    }

    public byte getId() {
        return this.id;
    }

    static {
        MAPPING = new HashMap<Byte, NBTCompression>();
        for (NBTCompression compression : NBTCompression.values()) {
            MAPPING.put(compression.getId(), compression);
        }
    }

    private static interface StreamFactory<S> {
        public S construct(S var1) throws IOException;
    }
}

