/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONObject;
import at.syntaxerror.json5.JSONOptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JSONParser {
    private final Reader reader;
    protected final JSONOptions options;
    protected boolean root = true;
    private boolean eof;
    private boolean back;
    private long index;
    private long character;
    private long line;
    private char previous;
    private char current;

    public JSONParser(Reader reader, JSONOptions options) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.options = options == null ? JSONOptions.getDefaultOptions() : options;
        this.eof = false;
        this.back = false;
        this.index = -1L;
        this.character = 0L;
        this.line = 1L;
        this.previous = '\u0000';
        this.current = '\u0000';
    }

    public JSONParser(String source, JSONOptions options) {
        this(new StringReader(source), options);
    }

    public JSONParser(InputStream stream, JSONOptions options) {
        this(new InputStreamReader(stream), options);
    }

    public JSONParser(Reader reader) {
        this(reader, null);
    }

    public JSONParser(String source) {
        this(source, null);
    }

    public JSONParser(InputStream stream) {
        this(stream, null);
    }

    private boolean more() {
        if (this.back || this.eof) {
            return this.back && !this.eof;
        }
        return this.peek() > '\u0000';
    }

    public void back() {
        this.back = true;
    }

    private char peek() {
        int c;
        if (this.eof) {
            return '\u0000';
        }
        try {
            this.reader.mark(1);
            c = this.reader.read();
            this.reader.reset();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not peek from source", e);
        }
        return c == -1 ? (char)'\u0000' : (char)c;
    }

    private char next() {
        int c;
        if (this.back) {
            this.back = false;
            return this.current;
        }
        try {
            c = this.reader.read();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not read from source", e);
        }
        if (c < 0) {
            this.eof = true;
            return '\u0000';
        }
        this.previous = this.current;
        this.current = (char)c;
        ++this.index;
        if (this.isLineTerminator(this.current) && (this.current != '\n' || this.current == '\n' && this.previous != '\r')) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        return this.current;
    }

    private boolean isLineTerminator(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2028': 
            case '\u2029': 
            case '\ufeff': {
                return true;
            }
        }
        return Character.getType(c) == 12;
    }

    private boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private void nextMultiLineComment() {
        char n;
        while ((n = this.next()) != '*' || this.peek() != '/') {
        }
        this.next();
    }

    private void nextSingleLineComment() {
        char n;
        while (!this.isLineTerminator(n = this.next()) && n != '\u0000') {
        }
    }

    public char nextClean() {
        char n;
        while (true) {
            if (!this.more()) {
                return '\u0000';
            }
            n = this.next();
            if (n == '/') {
                char p = this.peek();
                if (p == '*') {
                    this.next();
                    this.nextMultiLineComment();
                    continue;
                }
                if (p == '/') {
                    this.next();
                    this.nextSingleLineComment();
                    continue;
                }
                return n;
            }
            if (!this.isWhitespace(n)) break;
        }
        return n;
    }

    private String nextCleanTo(String delimiters) {
        StringBuilder result = new StringBuilder();
        while (true) {
            char n;
            if ((n = this.nextClean()) == '\u0000') {
                return null;
            }
            if (delimiters.indexOf(n) > -1 || this.isWhitespace(n)) break;
            result.append(n);
        }
        this.back();
        return result.toString();
    }

    private char[] unicodeEscape(boolean member, boolean part, boolean utf32) {
        if (utf32 && !this.options.isAllowLongUnicodeEscapes()) {
            throw this.syntaxError("Long unicode escape sequences are not allowed");
        }
        String where = member ? "key" : "string";
        String escChar = utf32 ? "U" : "u";
        Object value = "";
        int codepoint = 0;
        int numDigits = utf32 ? 8 : 4;
        for (int i = 0; i < numDigits; ++i) {
            char n = this.next();
            value = (String)value + n;
            int hex = JSONParser.dehex(n);
            if (hex == -1) {
                throw this.syntaxError("Illegal unicode escape sequence '\\" + escChar + (String)value + "' in " + where);
            }
            codepoint |= hex << (numDigits - i - 1 << 2);
        }
        if (member && !this.isMemberNameChar((char)codepoint, part)) {
            throw this.syntaxError("Illegal unicode escape sequence '\\" + escChar + (String)value + "' in key");
        }
        return Character.toChars(codepoint);
    }

    private void checkSurrogate(char hi, char lo) {
        if (this.options.isAllowInvalidSurrogates()) {
            return;
        }
        if (Character.isHighSurrogate(hi) && !Character.isSurrogate(lo) || !Character.isSurrogate(hi) && Character.isLowSurrogate(lo)) {
            throw this.syntaxError(String.format("Invalid surrogate pair: U+%04X and U+%04X", hi, (int)lo));
        }
    }

    private String nextString(char quote) {
        char prev;
        StringBuilder result = new StringBuilder();
        char n = '\u0000';
        block13: while (true) {
            if (!this.more()) {
                throw this.syntaxError("Expected '" + quote + "' to close string, got EOF instead");
            }
            prev = n;
            n = this.next();
            if (n == quote) break;
            if (this.isLineTerminator(n) && n != '\u2028' && n != '\u2029') {
                throw this.syntaxError("Unescaped line terminator in string");
            }
            if (n == '\\') {
                n = this.next();
                if (this.isLineTerminator(n)) {
                    if (n != '\r' || this.peek() != '\n') continue;
                    this.next();
                    continue;
                }
                switch (n) {
                    case '\u0000': {
                        throw this.syntaxError("Expected escape sequence in string, got EOF instead");
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(n);
                        continue block13;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block13;
                    }
                    case 't': {
                        result.append('\t');
                        continue block13;
                    }
                    case 'v': {
                        result.append('\u000b');
                        continue block13;
                    }
                    case '0': {
                        char p = this.peek();
                        if (this.isDecimalDigit(p)) {
                            throw this.syntaxError("Illegal escape sequence '\\0" + p + "'");
                        }
                        result.append('\u0000');
                        continue block13;
                    }
                    case 'x': {
                        Object value = "";
                        int codepoint = 0;
                        for (int i = 0; i < 2; ++i) {
                            n = this.next();
                            if (n == '\u0000') {
                                throw this.syntaxError("Expected hexadecimal digit for hexadecimal escape sequence in string, got EOF instead");
                            }
                            value = (String)value + n;
                            int hex = JSONParser.dehex(n);
                            if (hex == -1) {
                                throw this.syntaxError("Illegal hex escape sequence '\\x" + (String)value + "' in string");
                            }
                            codepoint |= hex << (1 - i << 2);
                        }
                        n = (char)codepoint;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        char[] chars = this.unicodeEscape(false, false, n == 'U');
                        if (chars.length == 2) {
                            this.checkSurrogate(prev, chars[0]);
                            prev = chars[0];
                            n = chars[1];
                            result.append(prev);
                            break;
                        }
                        n = chars[0];
                        break;
                    }
                    default: {
                        if (!this.isDecimalDigit(n)) break;
                        throw this.syntaxError("Illegal escape sequence '\\" + n + "'");
                    }
                }
            }
            this.checkSurrogate(prev, n);
            result.append(n);
        }
        this.checkSurrogate(prev, '\u0000');
        return result.toString();
    }

    private boolean isMemberNameChar(char n, boolean part) {
        if (n == '$' || n == '_' || n == '\u200c' || n == '\u200d') {
            return true;
        }
        int type = Character.getType(n);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
            case 6: 
            case 8: 
            case 9: 
            case 23: {
                if (!part) break;
                return true;
            }
        }
        return false;
    }

    public String nextMemberName() {
        StringBuilder result = new StringBuilder();
        char n = this.next();
        if (n == '\u0000') {
            throw this.syntaxError("Expected key, got EOF instead");
        }
        if (n == '\"' || n == '\'') {
            return this.nextString(n);
        }
        this.back();
        n = '\u0000';
        do {
            boolean part = result.length() > 0;
            char prev = n;
            n = this.next();
            if (n == '\\') {
                n = this.next();
                if (n == '\u0000') {
                    throw this.syntaxError("Expected escape sequence in key, got EOF instead");
                }
                if (n != 'u' && n != 'U') {
                    throw this.syntaxError("Illegal escape sequence '\\" + n + "' in key");
                }
                char[] chars = this.unicodeEscape(true, part, n == 'U');
                if (chars.length == 2) {
                    this.checkSurrogate(prev, chars[0]);
                    prev = chars[0];
                    n = chars[1];
                    result.append(prev);
                } else {
                    n = chars[0];
                }
            } else if (!this.isMemberNameChar(n, part)) {
                this.back();
                this.checkSurrogate(prev, '\u0000');
                break;
            }
            this.checkSurrogate(prev, n);
            result.append(n);
        } while (this.more());
        if (result.length() == 0) {
            throw this.syntaxError("Expected key");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextValue() {
        char n = this.nextClean();
        boolean wasRoot = this.root;
        try {
            switch (n) {
                case '\"': 
                case '\'': {
                    String string = this.nextString(n);
                    return string;
                }
                case '{': {
                    this.back();
                    this.root = false;
                    JSONObject jSONObject = new JSONObject(this);
                    return jSONObject;
                }
                case '[': {
                    this.back();
                    this.root = false;
                    JSONArray jSONArray = new JSONArray(this);
                    return jSONArray;
                }
            }
        }
        finally {
            this.root = wasRoot;
        }
        this.back();
        String string = this.nextCleanTo(",]}");
        if (string == null) {
            throw this.syntaxError("Expected value, got EOF instead");
        }
        if (string.equals("null")) {
            return null;
        }
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        if (string.isEmpty()) throw new JSONException("Illegal value '" + string + "'");
        char leading = string.charAt(0);
        String rest = string;
        double sign = 1.0;
        if (leading == '+') {
            rest = string.substring(1);
        } else if (leading == '-') {
            rest = string.substring(1);
            sign = -1.0;
        }
        if (rest.equals("Infinity")) {
            if (this.options.isAllowInfinity()) return Math.copySign(Double.POSITIVE_INFINITY, sign);
            throw this.syntaxError("Infinity is not allowed");
        }
        if (rest.equals("NaN")) {
            if (this.options.isAllowNaN()) return Math.copySign(Double.NaN, sign);
            throw this.syntaxError("NaN is not allowed");
        }
        if (rest.isEmpty()) throw new JSONException("Illegal value '" + string + "'");
        leading = rest.charAt(0);
        if (leading < '0' || leading > '9') {
            if (leading != '.') throw new JSONException("Illegal value '" + string + "'");
        }
        Number num = this.parseNumber(leading, rest);
        if (!(sign < 0.0)) return num;
        if (num instanceof BigInteger) {
            return ((BigInteger)num).negate();
        }
        if (!(num instanceof BigDecimal)) return num;
        return ((BigDecimal)num).negate();
    }

    private Number parseNumber(char leading, String input) {
        BigDecimal scale;
        BigInteger intValue = BigInteger.ZERO;
        int n = input.length();
        boolean floating = false;
        boolean hex = false;
        int off = 0;
        char c = '\u0000';
        if (leading == '0') {
            if (n == 1) {
                return intValue;
            }
            c = input.charAt(1);
            switch (c) {
                case 'B': 
                case 'b': {
                    if (!this.options.isAllowBinaryLiterals()) {
                        throw this.syntaxError("Binary literals are not allowed");
                    }
                    off = 2;
                    while (off < n) {
                        if (this.checkDigitSeparator(c = input.charAt(off++))) {
                            if (off != 3 && off < n && JSONParser.isbin(input.charAt(off))) continue;
                            throw this.syntaxError("Illegal position for digit separator");
                        }
                        if (!JSONParser.isbin(c)) {
                            throw this.syntaxError("Expected binary digit for literal");
                        }
                        intValue = intValue.shiftLeft(1);
                        if (c != '1') continue;
                        intValue = intValue.setBit(0);
                    }
                    if (off == 2) {
                        throw this.syntaxError("Expected binary digit after '0b'");
                    }
                    return intValue;
                }
                case 'O': 
                case 'o': {
                    if (!this.options.isAllowOctalLiterals()) {
                        throw this.syntaxError("Octal literals are not allowed");
                    }
                    off = 2;
                    while (off < n) {
                        if (this.checkDigitSeparator(c = input.charAt(off++))) {
                            if (off != 3 && off < n && JSONParser.isoct(input.charAt(off))) continue;
                            throw this.syntaxError("Illegal position for digit separator");
                        }
                        if (!JSONParser.isoct(c)) {
                            throw this.syntaxError("Expected octal digit for literal");
                        }
                        intValue = intValue.shiftLeft(3);
                        if (c == '0') continue;
                        intValue = intValue.or(BigInteger.valueOf(c - 48));
                    }
                    if (off == 2) {
                        throw this.syntaxError("Expected octal digit after '0o'");
                    }
                    return intValue;
                }
                case 'X': 
                case 'x': {
                    off = 2;
                    hex = true;
                    while (off < n) {
                        if (this.checkDigitSeparator(c = input.charAt(off++))) {
                            if (off != 3 && off < n && JSONParser.ishex(input.charAt(off))) continue;
                            throw this.syntaxError("Illegal position for digit separator");
                        }
                        if (c == '.' || c == 'p' || c == 'P') {
                            if (!this.options.isAllowHexFloatingLiterals()) {
                                throw this.syntaxError("Hexadecimal floating-point literals are not allowed");
                            }
                            floating = true;
                            break;
                        }
                        if (!JSONParser.ishex(c)) {
                            throw this.syntaxError("Expected hexadecimal digit for literal");
                        }
                        intValue = intValue.shiftLeft(4);
                        if (c == '0') continue;
                        intValue = intValue.or(BigInteger.valueOf(JSONParser.dehex(c)));
                    }
                    if (off == 2) {
                        throw this.syntaxError("Expected hexadecimal digit after '0x'");
                    }
                    if (floating) break;
                    return intValue;
                }
            }
        }
        StringBuilder num = new StringBuilder();
        if (!hex) {
            while (off < n) {
                if (this.checkDigitSeparator(c = input.charAt(off++))) {
                    if (num.length() != 0 && off < n && this.isDecimalDigit(input.charAt(off))) continue;
                    throw this.syntaxError("Illegal position for digit separator");
                }
                if (c == '.' || c == 'e' || c == 'E') {
                    floating = true;
                    break;
                }
                if (!this.isDecimalDigit(c)) {
                    throw this.syntaxError("Expected decimal digit for literal");
                }
                num.append(c);
            }
            if (off >= n) {
                if (this.options.isAllowJavaDigitSeparators()) {
                    input = input.replace("_", "");
                }
                if (this.options.isAllowCDigitSeparators()) {
                    input = input.replace("'", "");
                }
                return new BigInteger(input);
            }
        }
        BigInteger fractionInt = BigInteger.ZERO;
        int numFracDigits = 0;
        if (c == '.') {
            if (!hex) {
                num.append('.');
            }
            while (off < n) {
                if (this.checkDigitSeparator(c = input.charAt(off++))) {
                    if (numFracDigits == 0 || off >= n) {
                        throw this.syntaxError("Illegal position for digit separator");
                    }
                    c = input.charAt(off);
                    if ((hex || this.isDecimalDigit(c)) && (!hex || JSONParser.ishex(c))) continue;
                    throw this.syntaxError("Illegal position for digit separator");
                }
                if (hex) {
                    if (c == 'p' || c == 'P') break;
                    if (!JSONParser.ishex(c)) {
                        throw this.syntaxError("Expected hexadecimal digit for literal");
                    }
                    fractionInt = fractionInt.shiftLeft(4);
                    if (c != '0') {
                        fractionInt = fractionInt.or(BigInteger.valueOf(JSONParser.dehex(c)));
                    }
                } else {
                    if (c == 'e' || c == 'E') break;
                    if (!this.isDecimalDigit(c)) {
                        throw this.syntaxError("Expected decimal digit for literal");
                    }
                    num.append(c);
                }
                ++numFracDigits;
            }
            if (off >= n && !hex) {
                return new BigDecimal(num.toString());
            }
        }
        if (hex && c != 'p' && c != 'P') {
            throw this.syntaxError("Expected exponent for hexadecimal floating-point literal");
        }
        if (!hex) {
            num.append('e');
        }
        int numExpDigits = 0;
        if (++off >= n) {
            throw this.syntaxError("Expected digit sequence for exponent");
        }
        c = input.charAt(off);
        if (c == '+' || c == '-') {
            num.append(c);
            ++off;
        }
        while (off < n) {
            if (this.checkDigitSeparator(c = input.charAt(off++))) {
                if (numExpDigits != 0 && off < n && this.isDecimalDigit(input.charAt(off))) continue;
                throw this.syntaxError("Illegal position for digit separator");
            }
            if (!this.isDecimalDigit(c)) {
                throw this.syntaxError("Expected decimal digit for exponent");
            }
            num.append(c);
            ++numExpDigits;
        }
        if (numExpDigits == 0) {
            throw this.syntaxError("Expected digit sequence for exponent");
        }
        if (!hex) {
            return new BigDecimal(num.toString());
        }
        BigInteger exponent = new BigInteger(num.toString());
        BigDecimal value = new BigDecimal(intValue);
        BigDecimal two = BigDecimal.valueOf(2L);
        BigDecimal frac = BigDecimal.valueOf(0.5);
        for (int i = 4 * numFracDigits - 1; i >= 0; --i) {
            if (fractionInt.testBit(i)) {
                value = value.add(frac);
            }
            frac = frac.divide(two);
        }
        try {
            scale = new BigDecimal(BigInteger.TWO.pow(exponent.intValueExact()));
        }
        catch (Exception e) {
            throw this.syntaxError("Hexadecimal floating-point literal's exponent is too large");
        }
        return value.multiply(scale);
    }

    private boolean checkDigitSeparator(char c) {
        if (c == '_') {
            if (!this.options.isAllowJavaDigitSeparators()) {
                throw this.syntaxError("Java-style digit separators are not allowed");
            }
            return true;
        }
        if (c == '\'') {
            if (!this.options.isAllowCDigitSeparators()) {
                throw this.syntaxError("C-style digit separators are not allowed");
            }
            return true;
        }
        return false;
    }

    public JSONException syntaxError(String message, Throwable cause) {
        return new JSONException(message + this, cause);
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + this);
    }

    public String toString() {
        return " at index " + this.index + " [character " + this.character + " in line " + this.line + "]";
    }

    private static int dehex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static boolean isbin(char c) {
        return c == '0' || c == '1';
    }

    private static boolean isoct(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean ishex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    protected static String charToString(char c) {
        if (c == '\u0000') {
            return "EOF";
        }
        if (c <= '\u00ff' && !Character.isISOControl(c) || Character.isLetterOrDigit(c)) {
            return "'" + c + "'";
        }
        return String.format("U+%04X", c);
    }
}

