/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONOptions;
import at.syntaxerror.json5.JSONParser;
import at.syntaxerror.json5.JSONStringify;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class JSONObject
implements Iterable<Map.Entry<String, Object>> {
    private Map<String, Object> values = new HashMap<String, Object>();

    public JSONObject() {
    }

    public JSONObject(String source) {
        this(new JSONParser(source));
    }

    public JSONObject(JSONParser parser) {
        this();
        char c;
        if (parser.nextClean() != '{') {
            throw parser.syntaxError("A JSONObject must begin with '{'");
        }
        JSONOptions.DuplicateBehavior duplicateBehavior = parser.options.getDuplicateBehaviour();
        HashSet<String> duplicates = new HashSet<String>();
        do {
            c = parser.nextClean();
            switch (c) {
                case '\u0000': {
                    throw parser.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            parser.back();
            String key = parser.nextMemberName();
            boolean duplicate = this.has(key);
            if (duplicate && duplicateBehavior == JSONOptions.DuplicateBehavior.UNIQUE) {
                throw new JSONException("Duplicate key " + JSONStringify.quote(key));
            }
            c = parser.nextClean();
            if (c != ':') {
                throw parser.syntaxError("Expected ':' after a key, got '" + c + "' instead");
            }
            Object value = parser.nextValue();
            if (duplicate && duplicateBehavior == JSONOptions.DuplicateBehavior.DUPLICATE) {
                JSONArray array;
                if (duplicates.contains(key)) {
                    array = this.getArray(key);
                } else {
                    array = new JSONArray();
                    array.add(this.get(key));
                    duplicates.add(key);
                }
                array.add(value);
                value = array;
            }
            this.values.put(key, value);
            c = parser.nextClean();
            if (c != '}') continue;
            return;
        } while (c == ',');
        throw parser.syntaxError("Expected ',' or '}' after value, got '" + c + "' instead");
    }

    public JSONObject copy() {
        JSONObject copy = new JSONObject();
        copy.values.putAll(this.values);
        return copy;
    }

    public JSONObject deepCopy() {
        JSONObject copy = new JSONObject();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                value = ((JSONArray)value).deepCopy();
            } else if (value instanceof JSONObject) {
                value = ((JSONObject)value).deepCopy();
            }
            copy.values.put(key, value);
        }
        return copy;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof JSONObject) {
                value = ((JSONObject)((Object)value)).toMap();
            } else if (value instanceof JSONArray) {
                value = ((JSONArray)((Object)value)).toList();
            }
            map.put(entry.getKey(), value);
        }
        return map;
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    public void forEach(BiConsumer<String, Object> action) {
        this.forEach((? super T entry) -> action.accept((String)entry.getKey(), entry.getValue()));
    }

    public int length() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public void remove(String key) {
        this.checkKey(key);
        this.values.remove(key);
    }

    public JSONObject removeIf(BiPredicate<String, Object> predicate) {
        Iterator<Map.Entry<String, Object>> iter = this.values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            iter.remove();
        }
        return this;
    }

    public JSONObject removeIf(String key, Predicate<Object> predicate) {
        if (predicate.test(this.checkKey(key))) {
            this.values.remove(key);
        }
        return this;
    }

    private <T> JSONObject removeIf(String key, Predicate<T> predicate, Function<String, T> getter) {
        this.checkKey(key);
        if (predicate.test(getter.apply(key))) {
            this.values.remove(key);
        }
        return this;
    }

    public JSONObject removeBooleanIf(String key, Predicate<Boolean> predicate) {
        return this.removeIf(key, predicate, this::getBoolean);
    }

    public JSONObject removeByteIf(String key, Predicate<Byte> predicate) {
        return this.removeIf(key, predicate, this::getByte);
    }

    public JSONObject removeShortIf(String key, Predicate<Short> predicate) {
        return this.removeIf(key, predicate, this::getShort);
    }

    public JSONObject removeIntIf(String key, Predicate<Integer> predicate) {
        return this.removeIf(key, predicate, this::getInt);
    }

    public JSONObject removeLongIf(String key, Predicate<Long> predicate) {
        return this.removeIf(key, predicate, this::getLong);
    }

    public JSONObject removeFloatIf(String key, Predicate<Float> predicate) {
        return this.removeIf(key, predicate, this::getFloat);
    }

    public JSONObject removeDoubleIf(String key, Predicate<Double> predicate) {
        return this.removeIf(key, predicate, this::getDouble);
    }

    public JSONObject removeByteExactIf(String key, Predicate<Byte> predicate) {
        return this.removeIf(key, predicate, this::getByteExact);
    }

    public JSONObject removeShortExactIf(String key, Predicate<Short> predicate) {
        return this.removeIf(key, predicate, this::getShortExact);
    }

    public JSONObject removeIntExactIf(String key, Predicate<Integer> predicate) {
        return this.removeIf(key, predicate, this::getIntExact);
    }

    public JSONObject removeLongExactIf(String key, Predicate<Long> predicate) {
        return this.removeIf(key, predicate, this::getLongExact);
    }

    public JSONObject removeFloatExactIf(String key, Predicate<Float> predicate) {
        return this.removeIf(key, predicate, this::getFloatExact);
    }

    public JSONObject removeDoubleExactIf(String key, Predicate<Double> predicate) {
        return this.removeIf(key, predicate, this::getDoubleExact);
    }

    public JSONObject removeObjectIf(String key, Predicate<JSONObject> predicate) {
        return this.removeIf(key, predicate, this::getObject);
    }

    public JSONObject removeArrayIf(String key, Predicate<JSONArray> predicate) {
        return this.removeIf(key, predicate, this::getArray);
    }

    public JSONObject removeInstantIf(String key, Predicate<Instant> predicate) {
        return this.removeIf(key, predicate, this::getInstant);
    }

    public JSONObject removeKeys(JSONObject obj) {
        this.removeIf((key, value) -> obj.has((String)key));
        return this;
    }

    public JSONObject retainIf(BiPredicate<String, Object> predicate) {
        return this.removeIf(predicate.negate());
    }

    public JSONObject retainIf(String key, Predicate<Object> predicate) {
        return this.removeIf(key, predicate.negate());
    }

    private <T> JSONObject retainIf(String key, Predicate<T> predicate, Function<String, T> getter) {
        return this.removeIf(key, predicate.negate(), getter);
    }

    public JSONObject retainBooleanIf(String key, Predicate<Boolean> predicate) {
        return this.retainIf(key, predicate, this::getBoolean);
    }

    public JSONObject retainByteIf(String key, Predicate<Byte> predicate) {
        return this.retainIf(key, predicate, this::getByte);
    }

    public JSONObject retainShortIf(String key, Predicate<Short> predicate) {
        return this.retainIf(key, predicate, this::getShort);
    }

    public JSONObject retainIntIf(String key, Predicate<Integer> predicate) {
        return this.retainIf(key, predicate, this::getInt);
    }

    public JSONObject retainLongIf(String key, Predicate<Long> predicate) {
        return this.retainIf(key, predicate, this::getLong);
    }

    public JSONObject retainFloatIf(String key, Predicate<Float> predicate) {
        return this.retainIf(key, predicate, this::getFloat);
    }

    public JSONObject retainDoubleIf(String key, Predicate<Double> predicate) {
        return this.retainIf(key, predicate, this::getDouble);
    }

    public JSONObject retainByteExactIf(String key, Predicate<Byte> predicate) {
        return this.retainIf(key, predicate, this::getByteExact);
    }

    public JSONObject retainShortExactIf(String key, Predicate<Short> predicate) {
        return this.retainIf(key, predicate, this::getShortExact);
    }

    public JSONObject retainIntExactIf(String key, Predicate<Integer> predicate) {
        return this.retainIf(key, predicate, this::getIntExact);
    }

    public JSONObject retainLongExactIf(String key, Predicate<Long> predicate) {
        return this.retainIf(key, predicate, this::getLongExact);
    }

    public JSONObject retainFloatExactIf(String key, Predicate<Float> predicate) {
        return this.retainIf(key, predicate, this::getFloatExact);
    }

    public JSONObject retainDoubleExactIf(String key, Predicate<Double> predicate) {
        return this.retainIf(key, predicate, this::getDoubleExact);
    }

    public JSONObject retainObjectIf(String key, Predicate<JSONObject> predicate) {
        return this.retainIf(key, predicate, this::getObject);
    }

    public JSONObject retainArrayIf(String key, Predicate<JSONArray> predicate) {
        return this.retainIf(key, predicate, this::getArray);
    }

    public JSONObject retainInstantIf(String key, Predicate<Instant> predicate) {
        return this.retainIf(key, predicate, this::getInstant);
    }

    public JSONObject retainKeys(JSONObject obj) {
        this.removeIf((key, value) -> !obj.has((String)key));
        return this;
    }

    public boolean has(String key) {
        return this.values.containsKey(key);
    }

    public boolean isNull(String key) {
        return this.checkKey(key) == null;
    }

    public boolean isBoolean(String key) {
        return this.checkKey(key) instanceof Boolean;
    }

    public boolean isString(String key) {
        Object value = this.checkKey(key);
        return value instanceof String;
    }

    public boolean isNumber(String key) {
        Object value = this.checkKey(key);
        return value instanceof Number;
    }

    public boolean isObject(String key) {
        return this.checkKey(key) instanceof JSONObject;
    }

    public boolean isArray(String key) {
        return this.checkKey(key) instanceof JSONArray;
    }

    public boolean isInstant(String key) {
        Object val = this.checkKey(key);
        try {
            JSONObject.parseInstant(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object get(String key) {
        this.checkKey(key);
        return this.values.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.checkType(this::isBoolean, key, "boolean");
    }

    public String getString(String key) {
        return (String)this.checkType(this::isString, key, "string");
    }

    public Number getNumber(String key) {
        if (this.isInstant(key)) {
            return this.getInstant(key).getEpochSecond();
        }
        return (Number)this.checkType(this::isNumber, key, "number");
    }

    public byte getByte(String key) {
        return this.getNumber(key).byteValue();
    }

    public short getShort(String key) {
        return this.getNumber(key).shortValue();
    }

    public int getInt(String key) {
        return this.getNumber(key).intValue();
    }

    public long getLong(String key) {
        return this.getNumber(key).longValue();
    }

    public float getFloat(String key) {
        return this.getNumber(key).floatValue();
    }

    public double getDouble(String key) {
        return this.getNumber(key).doubleValue();
    }

    private <T> T getNumberExact(String key, String type, Function<BigInteger, T> bigint, Function<BigDecimal, T> bigdec) {
        Number number = this.getNumber(key);
        try {
            if (number instanceof BigInteger) {
                return bigint.apply((BigInteger)number);
            }
            if (number instanceof BigDecimal) {
                return bigdec.apply((BigDecimal)number);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw JSONObject.mismatch(key, type);
    }

    public byte getByteExact(String key) {
        return this.getNumberExact(key, "byte", BigInteger::byteValueExact, BigDecimal::byteValueExact);
    }

    public short getShortExact(String key) {
        return this.getNumberExact(key, "short", BigInteger::shortValueExact, BigDecimal::shortValueExact);
    }

    public int getIntExact(String key) {
        return this.getNumberExact(key, "int", BigInteger::intValueExact, BigDecimal::intValueExact);
    }

    public long getLongExact(String key) {
        return this.getNumberExact(key, "long", BigInteger::longValueExact, BigDecimal::longValueExact);
    }

    public float getFloatExact(String key) {
        Number num = this.getNumber(key);
        if (num instanceof Double) {
            return ((Double)num).floatValue();
        }
        float f = num.floatValue();
        if (!Float.isFinite(f)) {
            throw JSONObject.mismatch(key, "float");
        }
        return f;
    }

    public double getDoubleExact(String key) {
        Number num = this.getNumber(key);
        if (num instanceof Double) {
            return (Double)num;
        }
        double d = num.doubleValue();
        if (!Double.isFinite(d)) {
            throw JSONObject.mismatch(key, "double");
        }
        return d;
    }

    public JSONObject getObject(String key) {
        return (JSONObject)this.checkType(this::isObject, key, "object");
    }

    public JSONArray getArray(String key) {
        return (JSONArray)this.checkType(this::isArray, key, "array");
    }

    public Instant getInstant(String key) {
        Object val = this.checkKey(key);
        try {
            return JSONObject.parseInstant(val);
        }
        catch (Exception e) {
            throw JSONObject.mismatch(key, "instant");
        }
    }

    private <T> T getOpt(String key, Function<String, T> supplier, T defaults) {
        try {
            return supplier.apply(key);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public Object get(String key, Object defaults) {
        return this.getOpt(key, this::get, defaults);
    }

    public boolean getBoolean(String key, boolean defaults) {
        return this.getOpt(key, this::getBoolean, defaults);
    }

    public String getString(String key, String defaults) {
        return this.getOpt(key, this::getString, defaults);
    }

    public Number getNumber(String key, Number defaults) {
        return this.getOpt(key, this::getNumber, defaults);
    }

    public byte getByte(String key, byte defaults) {
        return this.getOpt(key, this::getByte, defaults);
    }

    public short getShort(String key, short defaults) {
        return this.getOpt(key, this::getShort, defaults);
    }

    public int getInt(String key, int defaults) {
        return this.getOpt(key, this::getInt, defaults);
    }

    public long getLong(String key, long defaults) {
        return this.getOpt(key, this::getLong, defaults);
    }

    public float getFloat(String key, float defaults) {
        return this.getOpt(key, this::getFloat, Float.valueOf(defaults)).floatValue();
    }

    public double getDouble(String key, double defaults) {
        return this.getOpt(key, this::getDouble, defaults);
    }

    public byte getByteExact(String key, byte defaults) {
        return this.getOpt(key, this::getByteExact, defaults);
    }

    public short getShortExact(String key, short defaults) {
        return this.getOpt(key, this::getShortExact, defaults);
    }

    public int getIntExact(String key, int defaults) {
        return this.getOpt(key, this::getIntExact, defaults);
    }

    public long getLongExact(String key, long defaults) {
        return this.getOpt(key, this::getLongExact, defaults);
    }

    public float getFloatExact(String key, float defaults) {
        return this.getOpt(key, this::getFloatExact, Float.valueOf(defaults)).floatValue();
    }

    public double getDoubleExact(String key, double defaults) {
        return this.getOpt(key, this::getDoubleExact, defaults);
    }

    public JSONObject getObject(String key, JSONObject defaults) {
        return this.getOpt(key, this::getObject, defaults);
    }

    public JSONArray getArray(String key, JSONArray defaults) {
        return this.getOpt(key, this::getArray, defaults);
    }

    public Instant getInstant(String key, Instant defaults) {
        return this.getOpt(key, this::getInstant, defaults);
    }

    public JSONObject putAll(JSONObject obj) {
        this.values.putAll(obj.values);
        return this;
    }

    public JSONObject putAllDeep(JSONObject obj) {
        this.values.putAll(obj.deepCopy().values);
        return this;
    }

    public JSONObject set(String key, Object value) {
        this.values.put(key, JSONObject.sanitize(value));
        return this;
    }

    public JSONObject setIfAbsent(String key, Object value) {
        if (!this.has(key)) {
            this.set(key, value);
        }
        return this;
    }

    public JSONObject setIfPresent(String key, Object value) {
        if (this.has(key)) {
            this.set(key, value);
        }
        return this;
    }

    public JSONObject compute(String key, BiFunction<String, Object, Object> remappingFunction) {
        this.values.compute(key, remappingFunction);
        return this;
    }

    private <T> JSONObject compute(String key, BiFunction<String, T, Object> remappingFunction, Function<String, T> getter) {
        Object value = this.has(key) ? (Object)getter.apply(key) : null;
        return this.set(key, remappingFunction.apply(key, (String)value));
    }

    public JSONObject computeBoolean(String key, BiFunction<String, Boolean, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getBoolean);
    }

    public JSONObject computeByte(String key, BiFunction<String, Byte, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getByte);
    }

    public JSONObject computeShort(String key, BiFunction<String, Short, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getShort);
    }

    public JSONObject computeInt(String key, BiFunction<String, Integer, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getInt);
    }

    public JSONObject computeLong(String key, BiFunction<String, Long, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getLong);
    }

    public JSONObject computeFloat(String key, BiFunction<String, Float, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getFloat);
    }

    public JSONObject computeDouble(String key, BiFunction<String, Double, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getDouble);
    }

    public JSONObject computeByteExact(String key, BiFunction<String, Byte, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getByteExact);
    }

    public JSONObject computeShortExact(String key, BiFunction<String, Short, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getShortExact);
    }

    public JSONObject computeIntExact(String key, BiFunction<String, Integer, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getIntExact);
    }

    public JSONObject computeLongExact(String key, BiFunction<String, Long, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getLongExact);
    }

    public JSONObject computeFloatExact(String key, BiFunction<String, Float, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getFloatExact);
    }

    public JSONObject computeDoubleExact(String key, BiFunction<String, Double, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getDoubleExact);
    }

    public JSONObject computeObject(String key, BiFunction<String, JSONObject, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getObject);
    }

    public JSONObject computeArray(String key, BiFunction<String, JSONArray, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getArray);
    }

    public JSONObject computeInstant(String key, BiFunction<String, Instant, Object> remappingFunction) {
        return this.compute(key, remappingFunction, this::getInstant);
    }

    public JSONObject computeIfPresent(String key, BiFunction<String, Object, Object> remappingFunction) {
        this.values.computeIfPresent(key, remappingFunction);
        return this;
    }

    private <T> JSONObject computeIfPresent(String key, BiFunction<String, T, Object> remappingFunction, Function<String, T> getter) {
        if (!this.has(key)) {
            return this;
        }
        return this.set(key, remappingFunction.apply(key, (String)getter.apply(key)));
    }

    public JSONObject computeBooleanIfPresent(String key, BiFunction<String, Boolean, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getBoolean);
    }

    public JSONObject computeByteIfPresent(String key, BiFunction<String, Byte, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getByte);
    }

    public JSONObject computeShortIfPresent(String key, BiFunction<String, Short, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getShort);
    }

    public JSONObject computeIntIfPresent(String key, BiFunction<String, Integer, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getInt);
    }

    public JSONObject computeLongIfPresent(String key, BiFunction<String, Long, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getLong);
    }

    public JSONObject computeFloatIfPresent(String key, BiFunction<String, Float, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getFloat);
    }

    public JSONObject computeDoubleIfPresent(String key, BiFunction<String, Double, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getDouble);
    }

    public JSONObject computeByteExactIfPresent(String key, BiFunction<String, Byte, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getByteExact);
    }

    public JSONObject computeShortExactIfPresent(String key, BiFunction<String, Short, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getShortExact);
    }

    public JSONObject computeIntExactIfPresent(String key, BiFunction<String, Integer, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getIntExact);
    }

    public JSONObject computeLongExactIfPresent(String key, BiFunction<String, Long, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getLongExact);
    }

    public JSONObject computeFloatExactIfPresent(String key, BiFunction<String, Float, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getFloatExact);
    }

    public JSONObject computeDoubleExactIfPresent(String key, BiFunction<String, Double, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getDoubleExact);
    }

    public JSONObject computeObjectIfPresent(String key, BiFunction<String, JSONObject, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getObject);
    }

    public JSONObject computeArrayIfPresent(String key, BiFunction<String, JSONArray, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getArray);
    }

    public JSONObject computeInstantIfPresent(String key, BiFunction<String, Instant, Object> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this::getInstant);
    }

    public JSONObject computeIfAbsent(String key, Function<String, Object> mappingFunction) {
        if (!this.has(key)) {
            this.set(key, mappingFunction.apply(key));
        }
        return this;
    }

    public String toString(int indentFactor) {
        return JSONStringify.toString(this, indentFactor);
    }

    public String toString() {
        return this.toString(0);
    }

    private Object checkKey(String key) {
        if (!this.values.containsKey(key)) {
            throw new JSONException("JSONObject[" + JSONStringify.quote(key) + "] does not exist");
        }
        return this.values.get(key);
    }

    private <T> T checkType(Predicate<String> predicate, String key, String type) {
        if (!predicate.test(key)) {
            throw JSONObject.mismatch(key, type);
        }
        return (T)this.values.get(key);
    }

    private static JSONException mismatch(String key, String type) {
        return new JSONException("JSONObject[" + JSONStringify.quote(key) + "] is not of type " + type);
    }

    public static Instant parseInstant(Object value) {
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return Instant.ofEpochSecond((Long)value);
        }
        if (value instanceof BigInteger) {
            return Instant.ofEpochSecond(((BigInteger)value).longValueExact());
        }
        if (value instanceof String) {
            return Instant.parse((String)value);
        }
        String className = value == null ? "null" : value.getClass().getSimpleName();
        throw new JSONException(className + " cannot be converted to Instant");
    }

    static Object sanitize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof JSONObject || value instanceof JSONArray || value instanceof Instant) {
            return value;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Double) {
                double d = (Double)num;
                if (Double.isFinite(d)) {
                    return BigDecimal.valueOf(d);
                }
            } else {
                if (value instanceof Float) {
                    float f = ((Float)num).floatValue();
                    if (Float.isFinite(f)) {
                        return BigDecimal.valueOf(f);
                    }
                    return num.doubleValue();
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                    return BigInteger.valueOf(num.longValue());
                }
                if (!(value instanceof BigDecimal) && !(value instanceof BigInteger)) {
                    return BigDecimal.valueOf(num.doubleValue());
                }
            }
            return num;
        }
        throw new JSONException("Illegal type '" + value.getClass() + "'");
    }
}

