/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONObject;
import at.syntaxerror.json5.JSONOptions;
import java.time.Instant;
import java.util.Map;

public class JSONStringify {
    private JSONStringify() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String toString(JSONObject object, int indentFactor, JSONOptions options) {
        return JSONStringify.toString(object, "", Math.max(0, indentFactor), options == null ? JSONOptions.getDefaultOptions() : options);
    }

    public static String toString(JSONArray array, int indentFactor, JSONOptions options) {
        return JSONStringify.toString(array, "", Math.max(0, indentFactor), options == null ? JSONOptions.getDefaultOptions() : options);
    }

    public static String toString(JSONObject object, int indentFactor) {
        return JSONStringify.toString(object, indentFactor, null);
    }

    public static String toString(JSONArray array, int indentFactor) {
        return JSONStringify.toString(array, indentFactor, null);
    }

    private static String toString(JSONObject object, String indent, int indentFactor, JSONOptions options) {
        StringBuilder sb = new StringBuilder();
        String childIndent = String.valueOf(indent) + " ".repeat(indentFactor);
        sb.append('{');
        for (Map.Entry<String, Object> entry : object) {
            if (sb.length() != 1) {
                sb.append(',');
            }
            if (indentFactor > 0) {
                sb.append('\n').append(childIndent);
            }
            sb.append(JSONStringify.quote(entry.getKey(), options)).append(':');
            if (indentFactor > 0) {
                sb.append(' ');
            }
            sb.append(JSONStringify.toString(entry.getValue(), childIndent, indentFactor, options));
        }
        if (indentFactor > 0) {
            sb.append('\n').append(indent);
        }
        sb.append('}');
        return sb.toString();
    }

    private static String toString(JSONArray array, String indent, int indentFactor, JSONOptions options) {
        StringBuilder sb = new StringBuilder();
        String childIndent = String.valueOf(indent) + " ".repeat(indentFactor);
        sb.append('[');
        for (Object value : array) {
            if (sb.length() != 1) {
                sb.append(',');
            }
            if (indentFactor > 0) {
                sb.append('\n').append(childIndent);
            }
            sb.append(JSONStringify.toString(value, childIndent, indentFactor, options));
        }
        if (indentFactor > 0) {
            sb.append('\n').append(indent);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String toString(Object value, String indent, int indentFactor, JSONOptions options) {
        if (value == null) {
            return "null";
        }
        if (value instanceof JSONObject) {
            return JSONStringify.toString((JSONObject)value, indent, indentFactor, options);
        }
        if (value instanceof JSONArray) {
            return JSONStringify.toString((JSONArray)value, indent, indentFactor, options);
        }
        if (value instanceof String) {
            return JSONStringify.quote((String)value, options);
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            if (options.isStringifyUnixInstants()) {
                return String.valueOf(instant.getEpochSecond());
            }
            return JSONStringify.quote(instant.toString(), options);
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (!options.isAllowNaN() && Double.isNaN(d)) {
                throw new JSONException("Illegal NaN in JSON");
            }
            if (!options.isAllowInfinity() && Double.isInfinite(d)) {
                throw new JSONException("Illegal Infinity in JSON");
            }
        }
        return String.valueOf(value);
    }

    static String quote(String string) {
        return JSONStringify.quote(string, null);
    }

    private static String quote(String string, JSONOptions options) {
        JSONOptions jSONOptions = options = options == null ? JSONOptions.getDefaultOptions() : options;
        if (string == null || string.isEmpty()) {
            return options.isQuoteSingle() ? "''" : "\"\"";
        }
        char qt = options.isQuoteSingle() ? (char)'\'' : '\"';
        StringBuilder quoted = new StringBuilder(string.length() + 2);
        quoted.append(qt);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == qt) {
                quoted.append('\\');
                quoted.append(c);
            } else {
                block0 : switch (c) {
                    case '\\': {
                        quoted.append("\\\\");
                        break;
                    }
                    case '\b': {
                        quoted.append("\\b");
                        break;
                    }
                    case '\f': {
                        quoted.append("\\f");
                        break;
                    }
                    case '\n': {
                        quoted.append("\\n");
                        break;
                    }
                    case '\r': {
                        quoted.append("\\r");
                        break;
                    }
                    case '\t': {
                        quoted.append("\\t");
                        break;
                    }
                    case '\u000b': {
                        quoted.append("\\v");
                        break;
                    }
                    default: {
                        switch (Character.getType(c)) {
                            case 0: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 18: 
                            case 19: {
                                quoted.append("\\u");
                                quoted.append(String.format("%04X", Character.valueOf(c)));
                                break block0;
                            }
                        }
                        quoted.append(c);
                    }
                }
            }
            ++n2;
        }
        quoted.append(qt);
        return quoted.toString();
    }
}

