/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONObject;
import at.syntaxerror.json5.JSONOptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.regex.Pattern;

public class JSONParser {
    private static final Pattern PATTERN_BOOLEAN = Pattern.compile("true|false");
    private static final Pattern PATTERN_NUMBER_FLOAT = Pattern.compile("[+-]?((0|[1-9]\\d*)(\\.\\d*)?|\\.\\d+)([eE][+-]?\\d+)?");
    private static final Pattern PATTERN_NUMBER_INTEGER = Pattern.compile("[+-]?(0|[1-9]\\d*)");
    private static final Pattern PATTERN_NUMBER_HEX = Pattern.compile("[+-]?0[xX][0-9a-fA-F]+");
    private static final Pattern PATTERN_NUMBER_SPECIAL = Pattern.compile("[+-]?(Infinity|NaN)");
    private final Reader reader;
    private final JSONOptions options;
    private boolean eof;
    private boolean back;
    private long index;
    private long character;
    private long line;
    private char previous;
    private char current;

    public JSONParser(Reader reader, JSONOptions options) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.options = options == null ? JSONOptions.getDefaultOptions() : options;
        this.eof = false;
        this.back = false;
        this.index = -1L;
        this.character = 0L;
        this.line = 1L;
        this.previous = '\u0000';
        this.current = '\u0000';
    }

    public JSONParser(String source, JSONOptions options) {
        this(new StringReader(source), options);
    }

    public JSONParser(InputStream stream, JSONOptions options) {
        this(new InputStreamReader(stream), options);
    }

    public JSONParser(Reader reader) {
        this(reader, null);
    }

    public JSONParser(String source) {
        this(source, null);
    }

    public JSONParser(InputStream stream) {
        this(stream, null);
    }

    private boolean more() {
        if (this.back || this.eof) {
            return this.back && !this.eof;
        }
        return this.peek() > '\u0000';
    }

    public void back() {
        this.back = true;
    }

    private char peek() {
        int c;
        if (this.eof) {
            return '\u0000';
        }
        try {
            this.reader.mark(1);
            c = this.reader.read();
            this.reader.reset();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not peek from source", e);
        }
        return c == -1 ? (char)'\u0000' : (char)c;
    }

    private char next() {
        int c;
        if (this.back) {
            this.back = false;
            return this.current;
        }
        try {
            c = this.reader.read();
        }
        catch (Exception e) {
            throw this.syntaxError("Could not read from source", e);
        }
        if (c < 0) {
            this.eof = true;
            return '\u0000';
        }
        this.previous = this.current;
        this.current = (char)c;
        ++this.index;
        if (this.isLineTerminator(this.current) && (this.current != '\n' || this.current == '\n' && this.previous != '\r')) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        return this.current;
    }

    private boolean isLineTerminator(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2028': 
            case '\u2029': 
            case '\ufeff': {
                return true;
            }
        }
        return Character.getType(c) == 12;
    }

    private boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private void nextMultiLineComment() {
        char n;
        while ((n = this.next()) != '*' || this.peek() != '/') {
        }
        this.next();
    }

    private void nextSingleLineComment() {
        char n;
        while (!this.isLineTerminator(n = this.next()) && n != '\u0000') {
        }
    }

    public char nextClean() {
        char n;
        while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            n = this.next();
            if (n == '/') {
                char p = this.peek();
                if (p == '*') {
                    this.next();
                    this.nextMultiLineComment();
                    continue;
                }
                if (p == '/') {
                    this.next();
                    this.nextSingleLineComment();
                    continue;
                }
                return n;
            }
            if (!this.isWhitespace(n)) break;
        }
        return n;
    }

    private String nextCleanTo(String delimiters) {
        StringBuilder result = new StringBuilder();
        while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            char n = this.nextClean();
            if (delimiters.indexOf(n) > -1 || this.isWhitespace(n)) break;
            result.append(n);
        }
        this.back();
        return result.toString();
    }

    private int dehex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private char unicodeEscape(boolean member, boolean part) {
        String where = member ? "key" : "string";
        String value = "";
        int codepoint = 0;
        int i = 0;
        while (i < 4) {
            char n = this.next();
            value = String.valueOf(value) + n;
            int hex = this.dehex(n);
            if (hex == -1) {
                throw this.syntaxError("Illegal unicode escape sequence '\\u" + value + "' in " + where);
            }
            codepoint |= hex << (3 - i << 2);
            ++i;
        }
        if (member && !this.isMemberNameChar((char)codepoint, part)) {
            throw this.syntaxError("Illegal unicode escape sequence '\\u" + value + "' in key");
        }
        return (char)codepoint;
    }

    private void checkSurrogate(char hi, char lo) {
        if (this.options.isAllowInvalidSurrogates()) {
            return;
        }
        if (!Character.isHighSurrogate(hi) || !Character.isLowSurrogate(lo)) {
            return;
        }
        if (!Character.isSurrogatePair(hi, lo)) {
            throw this.syntaxError(String.format("Invalid surrogate pair: U+%04X and U+%04X", Character.valueOf(hi), Character.valueOf(lo)));
        }
    }

    private String nextString(char quote) {
        StringBuilder result = new StringBuilder();
        char n = '\u0000';
        block12: while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            char prev = n;
            n = this.next();
            if (n == quote) break;
            if (this.isLineTerminator(n) && n != '\u2028' && n != '\u2029') {
                throw this.syntaxError("Unescaped line terminator in string");
            }
            if (n == '\\') {
                n = this.next();
                if (this.isLineTerminator(n)) {
                    if (n != '\r' || this.peek() != '\n') continue;
                    this.next();
                    continue;
                }
                switch (n) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(n);
                        continue block12;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block12;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block12;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block12;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block12;
                    }
                    case 't': {
                        result.append('\t');
                        continue block12;
                    }
                    case 'v': {
                        result.append('\u000b');
                        continue block12;
                    }
                    case '0': {
                        char p = this.peek();
                        if (this.isDecimalDigit(p)) {
                            throw this.syntaxError("Illegal escape sequence '\\0" + p + "'");
                        }
                        result.append('\u0000');
                        continue block12;
                    }
                    case 'x': {
                        String value = "";
                        int codepoint = 0;
                        int i = 0;
                        while (i < 2) {
                            n = this.next();
                            value = String.valueOf(value) + n;
                            int hex = this.dehex(n);
                            if (hex == -1) {
                                throw this.syntaxError("Illegal hex escape sequence '\\x" + value + "' in string");
                            }
                            codepoint |= hex << (1 - i << 2);
                            ++i;
                        }
                        n = (char)codepoint;
                        break;
                    }
                    case 'u': {
                        n = this.unicodeEscape(false, false);
                        break;
                    }
                    default: {
                        if (!this.isDecimalDigit(n)) break;
                        throw this.syntaxError("Illegal escape sequence '\\" + n + "'");
                    }
                }
            }
            this.checkSurrogate(prev, n);
            result.append(n);
        }
        return result.toString();
    }

    private boolean isMemberNameChar(char n, boolean part) {
        if (n == '$' || n == '_' || n == '\u200c' || n == '\u200d') {
            return true;
        }
        int type = Character.getType(n);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
            case 6: 
            case 8: 
            case 9: 
            case 23: {
                if (!part) break;
                return true;
            }
        }
        return false;
    }

    public String nextMemberName() {
        StringBuilder result = new StringBuilder();
        char n = this.next();
        if (n == '\"' || n == '\'') {
            return this.nextString(n);
        }
        this.back();
        n = '\u0000';
        while (true) {
            if (!this.more()) {
                throw this.syntaxError("Unexpected end of data");
            }
            boolean part = result.length() > 0;
            char prev = n;
            n = this.next();
            if (n == '\\') {
                n = this.next();
                if (n != 'u') {
                    throw this.syntaxError("Illegal escape sequence '\\" + n + "' in key");
                }
                n = this.unicodeEscape(true, part);
            } else if (!this.isMemberNameChar(n, part)) break;
            this.checkSurrogate(prev, n);
            result.append(n);
        }
        this.back();
        if (result.length() == 0) {
            throw this.syntaxError("Empty key");
        }
        return result.toString();
    }

    public Object nextValue() {
        String string;
        block37: {
            int factor;
            String special;
            char n = this.nextClean();
            switch (n) {
                case '\"': 
                case '\'': {
                    String string2 = this.nextString(n);
                    if (this.options.isParseInstants() && this.options.isParseStringInstants()) {
                        try {
                            return Instant.parse(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return string2;
                }
                case '{': {
                    this.back();
                    return new JSONObject(this);
                }
                case '[': {
                    this.back();
                    return new JSONArray(this);
                }
            }
            this.back();
            string = this.nextCleanTo(",]}");
            if (string.equals("null")) {
                return null;
            }
            if (PATTERN_BOOLEAN.matcher(string).matches()) {
                return string.equals("true");
            }
            if (PATTERN_NUMBER_INTEGER.matcher(string).matches()) {
                BigInteger bigint = new BigInteger(string);
                if (this.options.isParseInstants() && this.options.isParseUnixInstants()) {
                    try {
                        long unix = bigint.longValueExact();
                        return Instant.ofEpochSecond(unix);
                    }
                    catch (Exception unix) {
                        // empty catch block
                    }
                }
                return bigint;
            }
            if (PATTERN_NUMBER_FLOAT.matcher(string).matches()) {
                return new BigDecimal(string);
            }
            if (!PATTERN_NUMBER_SPECIAL.matcher(string).matches()) break block37;
            double d = 0.0;
            switch (string.charAt(0)) {
                case '+': {
                    special = string.substring(1);
                    factor = 1;
                    break;
                }
                case '-': {
                    special = string.substring(1);
                    factor = -1;
                    break;
                }
                default: {
                    special = string;
                    factor = 1;
                }
            }
            switch (special) {
                case "NaN": {
                    if (!this.options.isAllowNaN()) {
                        throw this.syntaxError("NaN is not allowed");
                    }
                    d = Double.NaN;
                    break;
                }
                case "Infinity": {
                    if (!this.options.isAllowInfinity()) {
                        throw this.syntaxError("Infinity is not allowed");
                    }
                    d = Double.POSITIVE_INFINITY;
                }
            }
            return (double)factor * d;
        }
        if (PATTERN_NUMBER_HEX.matcher(string).matches()) {
            int factor;
            String hex;
            switch (string.charAt(0)) {
                case '+': {
                    hex = string.substring(3);
                    factor = 1;
                    break;
                }
                case '-': {
                    hex = string.substring(3);
                    factor = -1;
                    break;
                }
                default: {
                    hex = string.substring(2);
                    factor = 1;
                }
            }
            BigInteger bigint = new BigInteger(hex, 16);
            if (factor == -1) {
                return bigint.negate();
            }
            return bigint;
        }
        throw new JSONException("Illegal value '" + string + "'");
    }

    public JSONException syntaxError(String message, Throwable cause) {
        return new JSONException(String.valueOf(message) + this, cause);
    }

    public JSONException syntaxError(String message) {
        return new JSONException(String.valueOf(message) + this);
    }

    public String toString() {
        return " at index " + this.index + " [character " + this.character + " in line " + this.line + "]";
    }
}

