/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONObject;
import at.syntaxerror.json5.JSONParser;
import at.syntaxerror.json5.JSONStringify;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class JSONArray
implements Iterable<Object> {
    private List<Object> values = new ArrayList<Object>();

    public JSONArray() {
    }

    public JSONArray(String source) {
        this(new JSONParser(source));
    }

    public JSONArray(JSONParser parser) {
        this();
        char c;
        if (parser.nextClean() != '[') {
            throw parser.syntaxError("A JSONArray must begin with '['");
        }
        do {
            c = parser.nextClean();
            switch (c) {
                case '\u0000': {
                    throw parser.syntaxError("A JSONArray must end with ']'");
                }
                case ']': {
                    return;
                }
            }
            parser.back();
            Object value = parser.nextValue();
            this.values.add(value);
            c = parser.nextClean();
            if (c != ']') continue;
            return;
        } while (c == ',');
        throw parser.syntaxError("Expected ',' or ']' after value, got '" + c + "' instead");
    }

    public List<Object> toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map<String, Object> value : this) {
            if (value instanceof JSONObject) {
                value = ((JSONObject)((Object)value)).toMap();
            } else if (value instanceof JSONArray) {
                value = ((JSONArray)((Object)value)).toList();
            }
            list.add(value);
        }
        return list;
    }

    public Collection<Object> entrySet() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public int length() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public void remove(int index) {
        this.checkIndex(index);
        this.values.remove(index);
    }

    public boolean isNull(int index) {
        return this.checkIndex(index) == null;
    }

    public boolean isBoolean(int index) {
        return this.checkIndex(index) instanceof Boolean;
    }

    public boolean isString(int index) {
        Object value = this.checkIndex(index);
        return value instanceof String || value instanceof Instant;
    }

    public boolean isNumber(int index) {
        Object value = this.checkIndex(index);
        return value instanceof Number || value instanceof Instant;
    }

    public boolean isObject(int index) {
        return this.checkIndex(index) instanceof JSONObject;
    }

    public boolean isArray(int index) {
        return this.checkIndex(index) instanceof JSONArray;
    }

    public boolean isInstant(int index) {
        return this.checkIndex(index) instanceof Instant;
    }

    public Object get(int index) {
        this.checkIndex(index);
        return this.values.get(index);
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.checkType(this::isBoolean, index, "boolean");
    }

    public String getString(int index) {
        return (String)this.checkType(this::isString, index, "string");
    }

    public Number getNumber(int index) {
        return (Number)this.checkType(this::isNumber, index, "number");
    }

    public byte getByte(int index) {
        return this.getNumber(index).byteValue();
    }

    public short getShort(int index) {
        return this.getNumber(index).shortValue();
    }

    public int getInt(int index) {
        return this.getNumber(index).intValue();
    }

    public long getLong(int index) {
        return this.getNumber(index).longValue();
    }

    public float getFloat(int index) {
        return this.getNumber(index).floatValue();
    }

    public double getDouble(int index) {
        return this.getNumber(index).doubleValue();
    }

    private <T> T getNumberExact(int index, String type, Function<BigInteger, T> bigint, Function<BigDecimal, T> bigdec) {
        Number number = this.getNumber(index);
        try {
            if (number instanceof BigInteger) {
                return bigint.apply((BigInteger)number);
            }
            if (number instanceof BigDecimal) {
                return bigdec.apply((BigDecimal)number);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw JSONArray.mismatch(index, type);
    }

    public byte getByteExact(int index) {
        return this.getNumberExact(index, "byte", BigInteger::byteValueExact, BigDecimal::byteValueExact);
    }

    public short getShortExact(int index) {
        return this.getNumberExact(index, "short", BigInteger::shortValueExact, BigDecimal::shortValueExact);
    }

    public int getIntExact(int index) {
        return this.getNumberExact(index, "int", BigInteger::intValueExact, BigDecimal::intValueExact);
    }

    public long getLongExact(int index) {
        return this.getNumberExact(index, "long", BigInteger::longValueExact, BigDecimal::longValueExact);
    }

    public float getFloatExact(int index) {
        Number num = this.getNumber(index);
        if (num instanceof Double) {
            return ((Double)num).floatValue();
        }
        float f = num.floatValue();
        if (!Float.isFinite(f)) {
            throw JSONArray.mismatch(index, "float");
        }
        return f;
    }

    public double getDoubleExact(int index) {
        Number num = this.getNumber(index);
        if (num instanceof Double) {
            return (Double)num;
        }
        double d = num.doubleValue();
        if (!Double.isFinite(d)) {
            throw JSONArray.mismatch(index, "double");
        }
        return d;
    }

    public JSONObject getObject(int index) {
        return (JSONObject)this.checkType(this::isObject, index, "object");
    }

    public JSONArray getArray(int index) {
        return (JSONArray)this.checkType(this::isArray, index, "array");
    }

    public Instant getInstant(int index) {
        return (Instant)this.checkType(this::isInstant, index, "instant");
    }

    private <T> T getOpt(int index, Function<Integer, T> supplier, T defaults) {
        try {
            return supplier.apply(index);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public Object get(int index, Object defaults) {
        return this.getOpt(index, this::get, defaults);
    }

    public boolean getBoolean(int index, boolean defaults) {
        return this.getOpt(index, this::getBoolean, defaults);
    }

    public String getString(int index, String defaults) {
        return this.getOpt(index, this::getString, defaults);
    }

    public Number getNumber(int index, Number defaults) {
        return this.getOpt(index, this::getNumber, defaults);
    }

    public byte getByte(int index, byte defaults) {
        return this.getOpt(index, this::getByte, defaults);
    }

    public short getShort(int index, short defaults) {
        return this.getOpt(index, this::getShort, defaults);
    }

    public int getInt(int index, int defaults) {
        return this.getOpt(index, this::getInt, defaults);
    }

    public long getLong(int index, long defaults) {
        return this.getOpt(index, this::getLong, defaults);
    }

    public float getFloat(int index, float defaults) {
        return this.getOpt(index, this::getFloat, Float.valueOf(defaults)).floatValue();
    }

    public double getDouble(int index, double defaults) {
        return this.getOpt(index, this::getDouble, defaults);
    }

    public byte getByteExact(int index, byte defaults) {
        return this.getOpt(index, this::getByteExact, defaults);
    }

    public short getShortExact(int index, short defaults) {
        return this.getOpt(index, this::getShortExact, defaults);
    }

    public int getIntExact(int index, int defaults) {
        return this.getOpt(index, this::getIntExact, defaults);
    }

    public long getLongExact(int index, long defaults) {
        return this.getOpt(index, this::getLongExact, defaults);
    }

    public float getFloatExact(int index, float defaults) {
        return this.getOpt(index, this::getFloatExact, Float.valueOf(defaults)).floatValue();
    }

    public double getDoubleExact(int index, double defaults) {
        return this.getOpt(index, this::getDoubleExact, defaults);
    }

    public JSONObject getObject(int index, JSONObject defaults) {
        return this.getOpt(index, this::getObject, defaults);
    }

    public JSONArray getArray(int index, JSONArray defaults) {
        return this.getOpt(index, this::getArray, defaults);
    }

    public Instant getInstant(int index, Instant defaults) {
        return this.getOpt(index, this::getInstant, defaults);
    }

    public JSONArray add(Object value) {
        this.values.add(JSONObject.sanitize(value));
        return this;
    }

    public JSONArray insert(int index, Object value) {
        if (index < 0 || index > this.length()) {
            throw new JSONException("JSONArray[" + index + "] is out of bounds");
        }
        this.values.add(index, JSONObject.sanitize(value));
        return this;
    }

    public JSONArray set(int index, Object value) {
        this.checkIndex(index);
        this.values.set(index, JSONObject.sanitize(value));
        return this;
    }

    public String toString(int indentFactor) {
        return JSONStringify.toString(this, indentFactor);
    }

    public String toString() {
        return this.toString(0);
    }

    private Object checkIndex(int index) {
        if (index < 0 || index >= this.length()) {
            throw new JSONException("JSONArray[" + index + "] does not exist");
        }
        return this.values.get(index);
    }

    private <T> T checkType(Predicate<Integer> predicate, int index, String type) {
        if (!predicate.test(index)) {
            throw JSONArray.mismatch(index, type);
        }
        return (T)this.values.get(index);
    }

    private static JSONException mismatch(int index, String type) {
        return new JSONException("JSONArray[" + index + "] is not of type " + type);
    }
}

