/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONObject;
import java.util.Map;

public class JSONStringify {
    private JSONStringify() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String toString(JSONObject object, int indentFactor) {
        return JSONStringify.toString(object, "", Math.max(0, indentFactor));
    }

    public static String toString(JSONArray array, int indentFactor) {
        return JSONStringify.toString(array, "", Math.max(0, indentFactor));
    }

    private static String toString(JSONObject object, String indent, int indentFactor) {
        StringBuilder sb = new StringBuilder();
        String childIndent = String.valueOf(indent) + " ".repeat(indentFactor);
        sb.append('{');
        for (Map.Entry<String, Object> entry : object) {
            if (sb.length() != 1) {
                sb.append(',');
            }
            if (indentFactor > 0) {
                sb.append('\n').append(childIndent);
            }
            sb.append(JSONStringify.quote(entry.getKey())).append(':');
            if (indentFactor > 0) {
                sb.append(' ');
            }
            sb.append(JSONStringify.toString(entry.getValue(), childIndent, indentFactor));
        }
        if (indentFactor > 0) {
            sb.append('\n').append(indent);
        }
        sb.append('}');
        return sb.toString();
    }

    private static String toString(JSONArray array, String indent, int indentFactor) {
        StringBuilder sb = new StringBuilder();
        String childIndent = String.valueOf(indent) + " ".repeat(indentFactor);
        sb.append('[');
        for (Object value : array) {
            if (sb.length() != 1) {
                sb.append(',');
            }
            if (indentFactor > 0) {
                sb.append('\n').append(childIndent);
            }
            sb.append(JSONStringify.toString(value, childIndent, indentFactor));
        }
        if (indentFactor > 0) {
            sb.append('\n').append(indent);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String toString(Object value, String indent, int indentFactor) {
        if (value == null) {
            return "null";
        }
        if (value instanceof JSONObject) {
            return JSONStringify.toString((JSONObject)value, indent, indentFactor);
        }
        if (value instanceof JSONArray) {
            return JSONStringify.toString((JSONArray)value, indent, indentFactor);
        }
        if (value instanceof String) {
            return JSONStringify.quote((String)value);
        }
        return String.valueOf(value);
    }

    static String quote(String string) {
        if (string == null || string.isEmpty()) {
            return "\"\"";
        }
        StringBuilder quoted = new StringBuilder(string.length() + 2);
        quoted.append('\"');
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            block0 : switch (c) {
                case '\"': 
                case '\\': {
                    quoted.append('\\');
                    quoted.append(c);
                    break;
                }
                case '\b': {
                    quoted.append("\\b");
                    break;
                }
                case '\f': {
                    quoted.append("\\f");
                    break;
                }
                case '\n': {
                    quoted.append("\\n");
                    break;
                }
                case '\r': {
                    quoted.append("\\r");
                    break;
                }
                case '\t': {
                    quoted.append("\\t");
                    break;
                }
                case '\u000b': {
                    quoted.append("\\v");
                    break;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 0: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: {
                            quoted.append("\\u");
                            quoted.append(String.format("%04X", Character.valueOf(c)));
                            break block0;
                        }
                    }
                    quoted.append(c);
                }
            }
            ++n2;
        }
        quoted.append('\"');
        return quoted.toString();
    }
}

