/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.json5;

import at.syntaxerror.json5.JSONArray;
import at.syntaxerror.json5.JSONException;
import at.syntaxerror.json5.JSONParser;
import at.syntaxerror.json5.JSONStringify;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class JSONObject
implements Iterable<Map.Entry<String, Object>> {
    private Map<String, Object> values = new HashMap<String, Object>();

    public JSONObject() {
    }

    public JSONObject(String source) {
        this(new JSONParser(source));
    }

    public JSONObject(JSONParser parser) {
        this();
        char c;
        if (parser.nextClean() != '{') {
            throw parser.syntaxError("A JSONObject must begin with '{'");
        }
        do {
            c = parser.nextClean();
            switch (c) {
                case '\u0000': {
                    throw parser.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            parser.back();
            String key = parser.nextMemberName();
            if (this.has(key)) {
                throw new JSONException("Duplicate key " + JSONStringify.quote(key));
            }
            c = parser.nextClean();
            if (c != ':') {
                throw parser.syntaxError("Expected ':' after a key, got '" + c + "' instead");
            }
            Object value = parser.nextValue();
            this.values.put(key, value);
            c = parser.nextClean();
            if (c != '}') continue;
            return;
        } while (c == ',');
        throw parser.syntaxError("Expected ',' or '}' after value, got '" + c + "' instead");
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof JSONObject) {
                value = ((JSONObject)((Object)value)).toMap();
            } else if (value instanceof JSONArray) {
                value = ((JSONArray)((Object)value)).toList();
            }
            map.put(entry.getKey(), value);
        }
        return map;
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    public int length() {
        return this.values.size();
    }

    public boolean has(String key) {
        return this.values.containsKey(key);
    }

    public boolean isNull(String key) {
        return this.checkKey(key) == null;
    }

    public boolean isBoolean(String key) {
        return this.checkKey(key) instanceof Boolean;
    }

    public boolean isString(String key) {
        return this.checkKey(key) instanceof String;
    }

    public boolean isNumber(String key) {
        return this.checkKey(key) instanceof Number;
    }

    public boolean isObject(String key) {
        return this.checkKey(key) instanceof JSONObject;
    }

    public boolean isArray(String key) {
        return this.checkKey(key) instanceof JSONArray;
    }

    public Object get(String key) {
        this.checkKey(key);
        return this.values.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.checkType(this::isBoolean, key, "boolean");
    }

    public String getString(String key) {
        return (String)this.checkType(this::isString, key, "string");
    }

    public Number getNumber(String key) {
        return (Number)this.checkType(this::isNumber, key, "number");
    }

    public byte getByte(String key) {
        return this.getNumber(key).byteValue();
    }

    public short getShort(String key) {
        return this.getNumber(key).shortValue();
    }

    public int getInt(String key) {
        return this.getNumber(key).intValue();
    }

    public long getLong(String key) {
        return this.getNumber(key).longValue();
    }

    public float getFloat(String key) {
        return this.getNumber(key).floatValue();
    }

    public double getDouble(String key) {
        return this.getNumber(key).doubleValue();
    }

    private <T> T getNumberExact(String key, String type, Function<BigInteger, T> bigint, Function<BigDecimal, T> bigdec) {
        Number number = this.getNumber(key);
        try {
            if (number instanceof BigInteger) {
                return bigint.apply((BigInteger)number);
            }
            if (number instanceof BigDecimal) {
                return bigdec.apply((BigDecimal)number);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw JSONObject.mismatch(key, type);
    }

    public byte getByteExact(String key) {
        return this.getNumberExact(key, "byte", BigInteger::byteValueExact, BigDecimal::byteValueExact);
    }

    public short getShortExact(String key) {
        return this.getNumberExact(key, "short", BigInteger::shortValueExact, BigDecimal::shortValueExact);
    }

    public int getIntExact(String key) {
        return this.getNumberExact(key, "int", BigInteger::intValueExact, BigDecimal::intValueExact);
    }

    public long getLongExact(String key) {
        return this.getNumberExact(key, "long", BigInteger::longValueExact, BigDecimal::longValueExact);
    }

    public float getFloatExact(String key) {
        Number num = this.getNumber(key);
        if (num instanceof Double) {
            return ((Double)num).floatValue();
        }
        float f = num.floatValue();
        if (!Float.isFinite(f)) {
            throw JSONObject.mismatch(key, "float");
        }
        return f;
    }

    public double getDoubleExact(String key) {
        Number num = this.getNumber(key);
        if (num instanceof Double) {
            return (Double)num;
        }
        double d = num.doubleValue();
        if (!Double.isFinite(d)) {
            throw JSONObject.mismatch(key, "double");
        }
        return d;
    }

    public JSONObject getObject(String key) {
        return (JSONObject)this.checkType(this::isObject, key, "object");
    }

    public JSONArray getArray(String key) {
        return (JSONArray)this.checkType(this::isArray, key, "array");
    }

    private <T> T getOpt(String key, Function<String, T> supplier, T defaults) {
        try {
            return supplier.apply(key);
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public Object get(String key, Object defaults) {
        return this.getOpt(key, this::get, defaults);
    }

    public boolean getBoolean(String key, boolean defaults) {
        return this.getOpt(key, this::getBoolean, defaults);
    }

    public String getString(String key, String defaults) {
        return this.getOpt(key, this::getString, defaults);
    }

    public Number getNumber(String key, Number defaults) {
        return this.getOpt(key, this::getNumber, defaults);
    }

    public byte getByte(String key, byte defaults) {
        return this.getOpt(key, this::getByte, defaults);
    }

    public short getShort(String key, short defaults) {
        return this.getOpt(key, this::getShort, defaults);
    }

    public int getInt(String key, int defaults) {
        return this.getOpt(key, this::getInt, defaults);
    }

    public long getLong(String key, long defaults) {
        return this.getOpt(key, this::getLong, defaults);
    }

    public float getFloat(String key, float defaults) {
        return this.getOpt(key, this::getFloat, Float.valueOf(defaults)).floatValue();
    }

    public double getDouble(String key, double defaults) {
        return this.getOpt(key, this::getDouble, defaults);
    }

    public byte getByteExact(String key, byte defaults) {
        return this.getOpt(key, this::getByteExact, defaults);
    }

    public short getShortExact(String key, short defaults) {
        return this.getOpt(key, this::getShortExact, defaults);
    }

    public int getIntExact(String key, int defaults) {
        return this.getOpt(key, this::getIntExact, defaults);
    }

    public long getLongExact(String key, long defaults) {
        return this.getOpt(key, this::getLongExact, defaults);
    }

    public float getFloatExact(String key, float defaults) {
        return this.getOpt(key, this::getFloatExact, Float.valueOf(defaults)).floatValue();
    }

    public double getDoubleExact(String key, double defaults) {
        return this.getOpt(key, this::getDoubleExact, defaults);
    }

    public JSONObject getObject(String key, JSONObject defaults) {
        return this.getOpt(key, this::getObject, defaults);
    }

    public JSONArray getArray(String key, JSONArray defaults) {
        return this.getOpt(key, this::getArray, defaults);
    }

    public void set(String key, Object value) {
        this.values.put(key, JSONObject.sanitize(value));
    }

    private void setCheck(String key, Object value) {
        this.values.put(key, JSONObject.sanitize(JSONObject.checkNull(value)));
    }

    public void set(String key, boolean value) {
        this.setCheck(key, value);
    }

    public void set(String key, String value) {
        this.setCheck(key, value);
    }

    public void set(String key, Number value) {
        this.setCheck(key, value);
    }

    public void set(String key, byte value) {
        this.setCheck(key, value);
    }

    public void set(String key, short value) {
        this.setCheck(key, value);
    }

    public void set(String key, int value) {
        this.setCheck(key, value);
    }

    public void set(String key, long value) {
        this.setCheck(key, value);
    }

    public void set(String key, float value) {
        this.setCheck(key, Float.valueOf(value));
    }

    public void set(String key, double value) {
        this.setCheck(key, value);
    }

    public void set(String key, JSONObject value) {
        this.setCheck(key, value);
    }

    public void set(String key, JSONArray value) {
        this.setCheck(key, value);
    }

    public String toString(int indentFactor) {
        return JSONStringify.toString(this, indentFactor);
    }

    public String toString() {
        return this.toString(0);
    }

    private Object checkKey(String key) {
        if (!this.values.containsKey(key)) {
            throw new JSONException("JSONObject[" + JSONStringify.quote(key) + "] does not exist");
        }
        return this.values.get(key);
    }

    private <T> T checkType(Predicate<String> predicate, String key, String type) {
        if (!predicate.test(key)) {
            throw JSONObject.mismatch(key, type);
        }
        return (T)this.values.get(key);
    }

    private static JSONException mismatch(String key, String type) {
        return new JSONException("JSONObject[" + JSONStringify.quote(key) + "] is not of type " + type);
    }

    static Object checkNull(Object value) {
        if (value == null) {
            throw new JSONException("Value is null");
        }
        return value;
    }

    static Object sanitize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof JSONObject || value instanceof JSONArray) {
            return value;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Double) {
                double d = (Double)num;
                if (Double.isFinite(d)) {
                    return BigDecimal.valueOf(d);
                }
            } else {
                if (value instanceof Float) {
                    float f = ((Float)num).floatValue();
                    if (Float.isFinite(f)) {
                        return BigDecimal.valueOf(f);
                    }
                    return num.doubleValue();
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                    return BigInteger.valueOf(num.longValue());
                }
                if (!(value instanceof BigDecimal) && !(value instanceof BigInteger)) {
                    return BigDecimal.valueOf(num.doubleValue());
                }
            }
            return num;
        }
        throw new JSONException("Illegal type '" + value.getClass() + "'");
    }
}

