/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.rounding;

import at.syntaxerror.ieee754.rounding.Rounding;
import java.math.BigDecimal;
import java.math.RoundingMode;

enum RoundingImpl {
    TIES_EVEN(RoundingMode.HALF_EVEN){

        @Override
        protected boolean round(boolean sign, boolean guard, boolean round, boolean sticky) {
            return guard && round || round && sticky;
        }
    }
    ,
    TIES_AWAY(RoundingMode.HALF_UP){

        @Override
        protected boolean round(boolean sign, boolean guard, boolean round, boolean sticky) {
            return round;
        }
    }
    ,
    TOWARD_ZERO(RoundingMode.DOWN){

        @Override
        protected boolean round(boolean sign, boolean guard, boolean round, boolean sticky) {
            return false;
        }
    }
    ,
    TOWARD_POSITIVE(RoundingMode.CEILING){

        @Override
        protected boolean round(boolean sign, boolean guard, boolean round, boolean sticky) {
            return !sign && (round || sticky);
        }
    }
    ,
    TOWARD_NEGATIVE(RoundingMode.FLOOR){

        @Override
        protected boolean round(boolean sign, boolean guard, boolean round, boolean sticky) {
            return sign && (round || sticky);
        }
    };

    private final Rounding instance;

    private RoundingImpl(final RoundingMode decimalMode) {
        this.instance = new Rounding(){

            @Override
            public BigDecimal roundDecimal(BigDecimal value) {
                return value.setScale(0, decimalMode);
            }

            @Override
            public boolean roundBinary(boolean sign, boolean guard, boolean round, boolean sticky) {
                return RoundingImpl.this.round(sign, guard, round, sticky);
            }
        };
    }

    protected abstract boolean round(boolean var1, boolean var2, boolean var3, boolean var4);

    private RoundingImpl(Rounding instance) {
        this.instance = instance;
    }

    public Rounding getInstance() {
        return this.instance;
    }
}

