/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.decimal;

import at.syntaxerror.ieee754.Floating;
import at.syntaxerror.ieee754.FloatingCodec;
import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.decimal.Decimal;
import at.syntaxerror.ieee754.decimal.DecimalCoding;
import at.syntaxerror.ieee754.rounding.Rounding;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;

public class DecimalCodec<T extends Decimal<T>>
extends FloatingCodec<T> {
    private static final BigInteger MASK_SPECIAL = BigInteger.valueOf(60L);
    private static final BigInteger MASK_HIGH = BigInteger.valueOf(48L);
    private static final BigInteger MASK_INFINITY = BigInteger.valueOf(30L);
    private static final BigInteger MASK_NAN = BigInteger.valueOf(31L);
    private static final BigInteger MASK_NEGATIVE = BigInteger.valueOf(32L);
    private static final BigInteger THOUSAND = BigInteger.valueOf(1000L);
    private static final BigInteger COMBINATION_LARGE_DPD = BigInteger.valueOf(24L);
    private static final BigInteger COMBINATION_LARGE_BID = BigInteger.valueOf(3L);
    private static final int MEMOIZE_EXPBIAS = 0;
    private static final int MEMOIZE_SIGDIGS = 1;
    private static final int MEMOIZE_POS_INF = 2;
    private static final int MEMOIZE_NEG_INF = 3;
    private static final int MEMOIZE_SMINVAL = 4;
    private static final int MEMOIZE_MIN_VAL = 5;
    private static final int MEMOIZE_MAX_VAL = 6;
    private static final int MEMOIZE_EXRANGE = 7;
    private static final int MEMOIZE_EPSILON = 8;
    private final int combination;
    private final int significand;
    private final FloatingFactory<T> factory;
    private final Map<Integer, Object> memoized = new HashMap<Integer, Object>();
    private static final int[] DPD_MASKS = new int[]{0, 8, 10, 78, 12, 46, 14, 110};

    public DecimalCodec(int combination, int significand, @NonNull FloatingFactory<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (combination < 6) {
            throw new IllegalArgumentException("Illegal combination size < 6");
        }
        if (significand < 1) {
            throw new IllegalArgumentException("Illegal non-positive significand size");
        }
        if (significand % 10 != 0) {
            throw new IllegalArgumentException("Significand size must be a multiple of 10");
        }
        if (combination > 31) {
            throw new IllegalArgumentException("Combination size is too big");
        }
        this.combination = combination;
        this.significand = significand;
        this.factory = factory;
        this.getSignificandDigits();
        this.getBias();
        this.initialize();
    }

    private <R> R memoize(int id, Supplier<R> generator) {
        Object value = this.memoized.get(id);
        if (value == null) {
            value = generator.get();
            this.memoized.put(id, value);
        }
        return (R)value;
    }

    public int getCombinationBits() {
        return this.combination;
    }

    public int getSignificandBits() {
        return this.significand;
    }

    @Override
    public BigInteger encode(T value) {
        return Decimal.DEFAULT_CODING == DecimalCoding.DENSLY_PACKED_DECIMAL ? this.encodeDPD(value) : this.encodeBID(value);
    }

    public BigInteger encodeBID(T value) {
        BigInteger combination;
        EncodeInfo info = this.encodeCommon(value);
        if (info.special()) {
            return info.value();
        }
        BigInteger unscaled = info.value().abs();
        BigInteger encoded = unscaled.and(this.mask(this.significand));
        int mostSignificant = unscaled.shiftRight(this.significand).intValue();
        int scale = info.scale() + this.getBias();
        int shift = 0;
        if (mostSignificant > 7) {
            combination = COMBINATION_LARGE_BID;
            shift = 1;
        } else {
            combination = BigInteger.ZERO;
            shift = 3;
        }
        combination = combination.shiftLeft(this.combination - 3).or(BigInteger.valueOf(scale)).shiftLeft(shift).or(BigInteger.valueOf(mostSignificant & 7));
        encoded = encoded.or(combination.shiftLeft(this.significand));
        if (((Floating)value).isNegative()) {
            encoded = encoded.or(BigInteger.ONE.shiftLeft(this.significand + this.combination));
        }
        return encoded;
    }

    public BigInteger encodeDPD(T value) {
        EncodeInfo info = this.encodeCommon(value);
        if (info.special()) {
            return info.value();
        }
        BigInteger unscaled = info.value().abs();
        BigInteger encoded = BigInteger.ZERO;
        for (int i = 0; i < this.significand; i += 10) {
            int[] digs = this.getLeastSignificantDigits(unscaled);
            unscaled = unscaled.divide(THOUSAND);
            encoded = encoded.or(BigInteger.valueOf(this.encodeDPDBlock(digs[2], digs[1], digs[0])).shiftLeft(i));
        }
        int mostSignificant = this.getLeastSignificantDigits(unscaled)[0];
        int scale = info.scale() + this.getBias();
        BigInteger expHigh = BigInteger.valueOf(scale >> this.combination - 5);
        BigInteger expLow = BigInteger.valueOf(scale).and(this.mask(this.combination - 5));
        BigInteger combination = mostSignificant > 7 ? COMBINATION_LARGE_DPD.or(expHigh.shiftLeft(1)) : expHigh.shiftLeft(3);
        combination = combination.or(BigInteger.valueOf(mostSignificant & 7)).shiftLeft(this.combination - 5).or(expLow);
        encoded = encoded.or(combination.shiftLeft(this.significand));
        if (((Floating)value).isNegative()) {
            encoded = encoded.or(BigInteger.ONE.shiftLeft(this.significand + this.combination));
        }
        return encoded;
    }

    private int[] getLeastSignificantDigits(BigInteger value) {
        int[] digs = new int[3];
        for (int i = 0; i < 3; ++i) {
            BigInteger cleared = value.divide(BigInteger.TEN);
            digs[i] = value.subtract(cleared.multiply(BigInteger.TEN)).intValue();
            value = cleared;
        }
        return digs;
    }

    private int encodeDPDBlock(int a, int b, int c) {
        boolean largeA = a > 7;
        boolean largeB = b > 7;
        boolean largeC = c > 7;
        b &= 7;
        c &= 7;
        int encoded = (a &= 7) << 7;
        if (!(largeA || largeB || largeC)) {
            return encoded | b << 4 | c;
        }
        encoded |= c & 1 | (b & 1) << 4;
        if (!largeC) {
            encoded |= (c & 6) << (largeA ? 7 : 4);
        }
        if (!largeB) {
            encoded |= (b & 6) << (largeA && largeC ? 7 : 4);
        }
        return encoded | DPD_MASKS[(largeA ? 4 : 0) | (largeB ? 2 : 0) | (largeC ? 1 : 0)];
    }

    private EncodeInfo encodeCommon(T value) {
        BigInteger result;
        boolean special;
        int scale = 0;
        if (!((Floating)value).isFinite() || ((Floating)value).isZero()) {
            special = true;
            int signum = ((Floating)value).getSignum();
            result = ((Floating)value).isPositiveInfinity() ? this.getPositiveInfinity() : (((Floating)value).isNegativeInfinity() ? this.getNegativeInfinity() : (((Floating)value).isQuietNaN() ? this.getQuietNaN(signum) : (((Floating)value).isSignalingNaN() ? this.getSignalingNaN(signum) : this.getZero(signum))));
        } else {
            int max;
            special = false;
            BigDecimal bigdec = ((Floating)value).getBigDecimal().stripTrailingZeros();
            scale = bigdec.scale();
            int prec = bigdec.precision();
            if (prec > (max = this.getSignificandDigits())) {
                bigdec = this.truncateLeastSignificant(bigdec, prec - max);
                scale = bigdec.scale();
                prec = bigdec.precision();
            }
            result = bigdec.unscaledValue();
            scale = -scale;
            int maxExp = this.getExponentSpan() >> 1;
            int minExp = 2 - maxExp - max;
            if (scale > maxExp) {
                special = true;
                result = ((Floating)value).getSignum() == -1 ? this.getNegativeInfinity() : this.getPositiveInfinity();
            } else if (scale < 2 - maxExp - max) {
                bigdec = this.truncateLeastSignificant(bigdec, minExp - scale);
                result = bigdec.unscaledValue();
                scale = -bigdec.scale();
            }
        }
        return new EncodeInfo(special, result, scale);
    }

    private BigDecimal truncateLeastSignificant(BigDecimal value, int n) {
        BigDecimal precise = new BigDecimal(value.unscaledValue().divide(BigInteger.TEN.pow(n - 1))).divide(BigDecimal.TEN);
        return new BigDecimal(Rounding.DEFAULT_ROUNDING.roundDecimal(precise).toBigInteger(), value.scale() - n).stripTrailingZeros();
    }

    @Override
    public T decode(BigInteger value) {
        return Decimal.DEFAULT_CODING == DecimalCoding.DENSLY_PACKED_DECIMAL ? this.decodeDPD(value) : this.decodeBID(value);
    }

    public T decodeBID(BigInteger value) {
        int exponent;
        int digit;
        boolean sign = this.isNegative(value);
        BigInteger combination = this.getCombination(value);
        BigInteger combId = combination.shiftRight(this.combination - 6);
        BigInteger significand = this.getSignificand(value);
        DecodeInfo<T> info = this.decodeCommon(combId, sign);
        if (info.special()) {
            return (T)((Decimal)info.specialValue());
        }
        BigInteger exponentMask = this.mask(this.combination - 3);
        if (info.high()) {
            digit = 8 | combination.and(BigInteger.ONE).intValue();
            exponent = combination.shiftRight(1).and(exponentMask).intValue();
        } else {
            digit = combination.and(BigInteger.valueOf(7L)).intValue();
            exponent = combination.shiftRight(3).and(exponentMask).intValue();
        }
        significand = BigInteger.valueOf(digit).shiftLeft(this.significand).or(significand);
        if (this.getDigits(significand) > this.getSignificandDigits()) {
            significand = BigInteger.ZERO;
        }
        BigDecimal result = new BigDecimal(significand).multiply(this.pow10(exponent - this.getBias())).stripTrailingZeros();
        if (sign) {
            result = result.negate();
        }
        return (T)((Decimal)this.factory.create(sign ? -1 : 1, result));
    }

    public T decodeDPD(BigInteger value) {
        int exponent;
        int digit;
        boolean sign = this.isNegative(value);
        BigInteger combination = this.getCombination(value);
        BigInteger combId = combination.shiftRight(this.combination - 6);
        BigInteger significand = this.getSignificand(value);
        DecodeInfo<T> info = this.decodeCommon(combId, sign);
        if (info.special()) {
            return (T)((Decimal)info.specialValue());
        }
        BigInteger exponentMask = this.mask(this.combination - 5);
        if (info.high()) {
            digit = 8 | combId.shiftRight(1).and(BigInteger.ONE).intValue();
            exponent = combination.and(exponentMask).or(combination.shiftRight(this.combination - 4).and(BigInteger.valueOf(3L)).shiftLeft(this.combination - 5)).intValue();
        } else {
            digit = combId.shiftRight(1).and(BigInteger.valueOf(7L)).intValue();
            exponent = combination.and(exponentMask).or(combination.shiftRight(this.combination - 2).shiftLeft(this.combination - 5)).intValue();
        }
        BigInteger trueSignificand = BigInteger.valueOf(digit);
        for (int i = 0; i < this.significand; i += 10) {
            trueSignificand = trueSignificand.multiply(BigInteger.valueOf(1000L)).add(BigInteger.valueOf(this.decodeDPDBlock(significand.shiftRight(this.significand - i - 10).and(this.mask(10)).intValue())));
        }
        BigDecimal result = new BigDecimal(trueSignificand).multiply(this.pow10(exponent - this.getBias())).stripTrailingZeros();
        if (sign) {
            result = result.negate();
        }
        return (T)((Decimal)this.factory.create(sign ? -1 : 1, result));
    }

    private int decodeDPDBlock(int block) {
        if ((block & 8) == 0) {
            return (block & 7) + 10 * (block >> 4 & 7) + 100 * (block >> 7 & 7);
        }
        int c = block & 1;
        int b = block >> 4 & 1;
        int a = block >> 7 & 1;
        int modeC = block >> 1 & 3;
        int modeB = block >> 5 & 3;
        int part1 = modeB << 1;
        int part2 = (block >> 8 & 3) << 1;
        c = modeC == 1 ? (c |= part1) : (modeC == 2 || modeC == 3 && modeB == 0 ? (c |= part2) : (c |= 8));
        b = (modeC & 1) == 0 ? (b |= part1) : (modeC == 3 && modeB == 1 ? (b |= part2) : (b |= 8));
        a = (modeC & 2) == 0 || modeC == 3 && modeB == 2 ? (a |= part2) : (a |= 8);
        return 100 * a + 10 * b + c;
    }

    private DecodeInfo<T> decodeCommon(BigInteger combination, boolean sign) {
        boolean high = false;
        boolean special = false;
        Decimal specialValue = null;
        if (combination.and(MASK_SPECIAL).compareTo(MASK_SPECIAL) == 0) {
            int signum;
            special = true;
            int n = signum = sign ? -1 : 1;
            specialValue = combination.testBit(1) ? (Decimal)this.factory.create(signum, combination.testBit(0) ? FloatingType.SIGNALING_NAN : FloatingType.QUIET_NAN) : (Decimal)this.factory.create(signum, FloatingType.INFINITE);
        } else {
            high = combination.and(MASK_HIGH).compareTo(MASK_HIGH) == 0;
        }
        return new DecodeInfo<Object>(high, special, specialValue);
    }

    private BigInteger mask(int n) {
        return BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
    }

    private BigDecimal pow10(int n) {
        if (n == 0) {
            return BigDecimal.ONE;
        }
        if (n < 0) {
            return BigDecimal.ONE.divide(this.pow10(-n));
        }
        return BigDecimal.TEN.pow(n);
    }

    private int getDigits(BigInteger number) {
        BigDecimal dec = new BigDecimal(number);
        dec = dec.stripTrailingZeros();
        return dec.precision() - dec.scale();
    }

    private int getExponentSpan() {
        return BigInteger.TWO.pow(this.combination - 5).multiply(BigInteger.valueOf(3L)).intValue();
    }

    public int getBias() {
        return this.memoize(0, () -> BigInteger.valueOf(this.getSignificandDigits() - 2).add(BigInteger.valueOf(this.getExponentSpan() >> 1)).intValue());
    }

    public int getSignificandDigits() {
        return this.memoize(1, () -> 1 + this.significand / 10 * 3);
    }

    public BigInteger getCombination(BigInteger value) {
        return value.shiftRight(this.significand).and(this.mask(this.combination));
    }

    public BigInteger getSignificand(BigInteger value) {
        return value.and(this.mask(this.significand));
    }

    @Override
    public boolean isPositive(BigInteger value) {
        return !this.isNegative(value);
    }

    @Override
    public boolean isNegative(BigInteger value) {
        return value.testBit(this.significand + this.combination);
    }

    @Override
    public boolean isInfinity(BigInteger value) {
        return this.getCombination(value).shiftRight(this.combination - 5).compareTo(MASK_INFINITY) == 0;
    }

    @Override
    public boolean isPositiveInfinity(BigInteger value) {
        return this.isPositive(value) && this.isInfinity(value);
    }

    @Override
    public boolean isNegativeInfinity(BigInteger value) {
        return this.isNegative(value) && this.isInfinity(value);
    }

    @Override
    public BigInteger getPositiveInfinity() {
        return this.memoize(2, () -> MASK_INFINITY.shiftLeft(this.combination - 5 + this.significand));
    }

    @Override
    public BigInteger getNegativeInfinity() {
        return this.memoize(3, () -> MASK_INFINITY.or(MASK_NEGATIVE).shiftLeft(this.combination - 5 + this.significand));
    }

    @Override
    public boolean isNaN(BigInteger value) {
        return this.getCombination(value).shiftRight(this.combination - 5).compareTo(MASK_NAN) == 0;
    }

    @Override
    public boolean isQuietNaN(BigInteger value) {
        return this.isNaN(value) && !value.testBit(this.significand + this.combination - 6);
    }

    @Override
    public boolean isSignalingNaN(BigInteger value) {
        return this.isNaN(value) && value.testBit(this.significand + this.combination - 6);
    }

    @Override
    public BigInteger getQuietNaN(int signum) {
        return MASK_NAN.or(signum == -1 ? MASK_NEGATIVE : BigInteger.ZERO).shiftLeft(this.combination - 5 + this.significand);
    }

    @Override
    public BigInteger getSignalingNaN(int signum) {
        return MASK_NAN.or(signum == -1 ? MASK_NEGATIVE : BigInteger.ZERO).shiftLeft(1).or(BigInteger.ONE).shiftLeft(this.combination - 6 + this.significand);
    }

    @Override
    public BigInteger getNaN(int signum) {
        return this.getQuietNaN(signum);
    }

    @Override
    public BigInteger getZero(int signum) {
        return signum == -1 ? MASK_NEGATIVE.shiftLeft(this.combination - 5 + this.significand) : BigInteger.ZERO;
    }

    @Override
    public T getMinSubnormalValue() {
        return (T)this.memoize(4, () -> this.decodeBID(BigInteger.ONE));
    }

    @Override
    public T getMinValue() {
        return (T)this.memoize(5, () -> this.decodeDPD(BigInteger.ONE.shiftLeft(this.significand + this.combination - 5)));
    }

    @Override
    public T getMaxValue() {
        return (T)this.memoize(6, () -> this.decodeDPD(BigInteger.valueOf(7L).shiftLeft(this.significand + this.combination - 3).or(this.mask(this.significand + this.combination - 4))));
    }

    @Override
    public BigDecimal getEpsilon() {
        return this.memoize(8, () -> {
            int bias = this.getBias() - this.getSignificandDigits() + 1;
            int lo = bias & this.mask(this.combination - 5).intValue();
            int hi = bias >> this.combination - 5;
            BigInteger value = BigInteger.valueOf(hi).shiftLeft(3).or(BigInteger.ONE).shiftLeft(this.combination - 5).or(BigInteger.valueOf(lo)).shiftLeft(this.significand).or(BigInteger.ONE);
            return ((Floating)this.decodeDPD(value)).getBigDecimal().subtract(BigDecimal.ONE);
        });
    }

    @Override
    public Map.Entry<Integer, Integer> getExponentRange() {
        return this.memoize(7, () -> {
            int span = this.getExponentSpan() >> 1;
            return Map.entry(2 - span, 1 + span);
        });
    }

    private record EncodeInfo(boolean special, BigInteger value, int scale) {
    }

    private record DecodeInfo<T>(boolean high, boolean special, T specialValue) {
    }
}

