/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.decimal;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.decimal.Decimal;
import at.syntaxerror.ieee754.decimal.DecimalCodec;
import java.math.BigDecimal;

public final class Decimal128
extends Decimal<Decimal128> {
    public static final FloatingFactory<Decimal128> FACTORY = new Binary32Factory();
    public static final DecimalCodec<Decimal128> CODEC = new DecimalCodec<Decimal128>(17, 110, FACTORY);
    public static final Decimal128 POSITIVE_INFINITY = new Decimal128(1, FloatingType.INFINITE);
    public static final Decimal128 NEGATIVE_INFINITY = new Decimal128(-1, FloatingType.INFINITE);
    public static final Decimal128 QUIET_NAN = new Decimal128(1, FloatingType.QUIET_NAN);
    public static final Decimal128 SIGNALING_NAN = new Decimal128(1, FloatingType.SIGNALING_NAN);
    public static final Decimal128 MAX_VALUE = (Decimal128)CODEC.getMaxValue();
    public static final Decimal128 MIN_VALUE = (Decimal128)CODEC.getMinSubnormalValue();
    public static final Decimal128 MIN_NORMAL = (Decimal128)CODEC.getMinValue();

    private Decimal128(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Decimal128(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public DecimalCodec<Decimal128> getCodec() {
        return CODEC;
    }

    private static class Binary32Factory
    implements FloatingFactory<Decimal128> {
        private Binary32Factory() {
        }

        @Override
        public Decimal128 create(int signum, BigDecimal value) {
            return new Decimal128(signum, value);
        }

        @Override
        public Decimal128 create(int signum, FloatingType type) {
            return new Decimal128(signum, type);
        }
    }
}

