/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.Floating;
import at.syntaxerror.ieee754.FloatingCodec;
import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.rounding.Rounding;
import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;

public final class BinaryCodec<T extends Binary<T>>
extends FloatingCodec<T> {
    private static final MathContext FLOOR = new MathContext(0, RoundingMode.FLOOR);
    private static final MathContext CONTEXT = new MathContext(800);
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal LOG10_2 = BigDecimalMath.log10((BigDecimal)TWO, (MathContext)new MathContext(604, RoundingMode.HALF_EVEN));
    private static final int MEMOIZE_POS_INF = 0;
    private static final int MEMOIZE_NEG_INF = 1;
    private static final int MEMOIZE_SMINVAL = 2;
    private static final int MEMOIZE_MIN_VAL = 3;
    private static final int MEMOIZE_MAX_VAL = 4;
    private static final int MEMOIZE_EPSILON = 5;
    private static final int MEMOIZE_EXRANGE = 6;
    private static final int MEMOIZE_EX10RNG = 7;
    private static final int MEMOIZE_DECDIGS = 8;
    private static final int MEMOIZE_POWEXP1 = 9;
    private static final int MEMOIZE_POWMANT = 10;
    private final int exponent;
    private final int significand;
    private final boolean implicit;
    private final FloatingFactory<T> factory;
    private final Map<Integer, Object> memoized = new HashMap<Integer, Object>();

    public BinaryCodec(int exponent, int significand, boolean implicit, @NonNull FloatingFactory<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (exponent < 1) {
            throw new IllegalArgumentException("Illegal non-positive exponent size");
        }
        if (significand < 1) {
            throw new IllegalArgumentException("Illegal non-positive significand size");
        }
        if (exponent > 31) {
            throw new IllegalArgumentException("Exponent size is too big");
        }
        this.exponent = exponent;
        this.significand = significand;
        this.implicit = implicit;
        this.factory = factory;
        this.initialize();
    }

    private <R> R memoize(int id, Supplier<R> generator) {
        Object value = this.memoized.get(id);
        if (value == null) {
            value = generator.get();
            this.memoized.put(id, value);
        }
        return (R)value;
    }

    public int getExponentBits() {
        return this.exponent;
    }

    public int getSignificandBits() {
        return this.significand;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public BigInteger encode(T value) {
        int newBits;
        int bits;
        if (!((Floating)value).isFinite()) {
            if (((Floating)value).isSignalingNaN()) {
                return this.getSignalingNaN(((Floating)value).getSignum());
            }
            if (((Floating)value).isQuietNaN()) {
                return this.getQuietNaN(((Floating)value).getSignum());
            }
            if (((Floating)value).isPositiveInfinity()) {
                return this.getPositiveInfinity();
            }
            if (((Floating)value).isNegativeInfinity()) {
                return this.getNegativeInfinity();
            }
            assert (false) : "unreachable";
        }
        if (((Floating)value).isZero()) {
            return this.getZero(((Floating)value).getSignum());
        }
        BigDecimal bigdec = ((Floating)value).getBigDecimal();
        int sign = bigdec.signum() == -1 ? 1 : 0;
        bigdec = bigdec.abs();
        BigInteger significand = bigdec.toBigInteger();
        BigDecimal fraction = bigdec.subtract(new BigDecimal(significand)).abs().stripTrailingZeros();
        significand = significand.abs();
        int exp = significand.bitLength() - 1;
        boolean negative = exp < 0;
        int zeros = 0;
        int off = this.getOffset();
        int eMin = this.getExponentRange().getKey();
        boolean requireRounding = false;
        boolean guard = false;
        boolean round = false;
        boolean sticky = false;
        if (fraction.compareTo(BigDecimal.ZERO) != 0) {
            zeros = BigDecimalMath.log2((BigDecimal)BigDecimalMath.reciprocal((BigDecimal)fraction, (MathContext)CONTEXT), (MathContext)CONTEXT).setScale(0, RoundingMode.CEILING).intValue() - 1;
            fraction = fraction.multiply(this.pow2(zeros)).stripTrailingZeros();
            significand = significand.shiftLeft(zeros);
            int bitCount = significand.bitLength();
            int threshold = this.significand + off;
            if (zeros > -eMin) {
                bitCount += zeros + eMin;
            }
            if (bitCount > threshold) {
                requireRounding = true;
                boolean bl = round = (fraction = fraction.multiply(BigDecimal.TWO)).intValue() != 0;
                if (round) {
                    fraction = fraction.subtract(BigDecimal.ONE);
                }
                sticky = fraction.compareTo(BigDecimal.ZERO) != 0;
                fraction = BigDecimal.ZERO;
            }
        }
        while (fraction.compareTo(BigDecimal.ZERO) != 0) {
            int bitCount;
            fraction = fraction.multiply(TWO);
            int integerPart = fraction.intValue();
            int significandLength = bitCount = significand.bitLength();
            if (zeros > -eMin) {
                significandLength += zeros + eMin;
            }
            if (significandLength > this.significand + off) {
                requireRounding = true;
                guard = significand.testBit(0);
                round = integerPart == 1;
                sticky = fraction.compareTo(BigDecimal.ONE) != 0;
                break;
            }
            significand = significand.shiftLeft(1);
            if (integerPart == 1) {
                significand = significand.or(BigInteger.ONE);
                fraction = fraction.subtract(BigDecimal.ONE);
                continue;
            }
            if (bitCount != 0) continue;
            ++zeros;
        }
        if (requireRounding && Rounding.DEFAULT_ROUNDING.roundBinary(sign == -1, guard, round, sticky) && (bits = significand.bitLength()) < (newBits = (significand = significand.add(BigInteger.ONE)).bitLength())) {
            if (newBits > this.significand + off) {
                significand = significand.clearBit(newBits - 1);
            }
            if (++exp == this.mask(this.exponent).intValue()) {
                return sign == -1 ? this.getNegativeInfinity() : this.getPositiveInfinity();
            }
        }
        int len = significand.bitLength();
        if (negative) {
            exp -= zeros;
        }
        if (exp < eMin) {
            return len == 0 ? this.getZero(sign) : BigInteger.valueOf(sign).shiftLeft(this.exponent + this.significand + off).or(significand.shiftLeft(this.significand - eMin + exp - len + 2));
        }
        if (this.implicit && len > 0) {
            significand = significand.clearBit(len - 1);
        }
        BigInteger result = BigInteger.valueOf(sign).shiftLeft(this.exponent).or(BigInteger.valueOf(exp + this.getBias())).shiftLeft(this.significand + off).or(significand.shiftLeft(this.significand - len + 1));
        if (!this.implicit) {
            result = result.or(BigInteger.ONE.shiftLeft(this.significand));
        }
        return result;
    }

    @Override
    public T decode(BigInteger value) {
        boolean sign = this.isNegative(value);
        BigInteger significand = this.getFullSignificand(value);
        int exponent = this.getExponent(value).intValue();
        int bias = this.getBias();
        boolean subnormal = false;
        if (exponent == 0) {
            if (significand.compareTo(BigInteger.ZERO) == 0) {
                return (T)((Binary)this.factory.create(sign ? -1 : 1, BigDecimal.ZERO));
            }
            exponent = 1 - bias;
            subnormal = true;
        } else {
            if (exponent == this.mask(this.exponent).intValue()) {
                int signum;
                int n = signum = sign ? -1 : 1;
                if (this.isInfinity(value)) {
                    return (T)((Binary)this.factory.create(signum, FloatingType.INFINITE));
                }
                return (T)((Binary)this.factory.create(signum, this.isSignalingNaN(value) ? FloatingType.SIGNALING_NAN : FloatingType.QUIET_NAN));
            }
            exponent -= bias;
        }
        BigDecimal result = BigDecimal.ZERO;
        if (this.implicit) {
            if (!subnormal) {
                result = result.add(BigDecimal.ONE);
            }
        } else if (significand.testBit(this.significand)) {
            result = result.add(BigDecimal.ONE);
        }
        for (int i = 0; i < this.significand; ++i) {
            if (!significand.testBit(this.significand - i - 1)) continue;
            result = result.add(this.pow2(-i - 1));
        }
        result = result.multiply(this.pow2(exponent));
        if (sign) {
            result = result.negate();
        }
        return (T)((Binary)this.factory.create(sign ? -1 : 1, result));
    }

    private BigInteger mask(int n) {
        return BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
    }

    private BigDecimal pow2(int n) {
        if (n == 0) {
            return BigDecimal.ONE;
        }
        if (n < 0) {
            return BigDecimalMath.reciprocal((BigDecimal)this.pow2(-n), (MathContext)CONTEXT);
        }
        return new BigDecimal(BigInteger.ONE.shiftLeft(n), 0).stripTrailingZeros();
    }

    private BigDecimal pow2exp1() {
        return this.memoize(9, () -> this.pow2(this.getExponentRange().getKey() - 1));
    }

    private BigDecimal pow2mant() {
        return this.memoize(10, () -> this.pow2(-this.significand));
    }

    private int getOffset() {
        return this.implicit ? 0 : 1;
    }

    public int getBias() {
        return (1 << this.exponent - 1) - 1;
    }

    public BigInteger getUnbiasedExponent(BigInteger value) {
        return this.getExponent(value).subtract(BigInteger.valueOf(this.getBias()));
    }

    public BigInteger getExponent(BigInteger value) {
        return value.shiftRight(this.significand + this.getOffset()).and(this.mask(this.exponent));
    }

    public BigInteger getSignificand(BigInteger value) {
        return value.and(this.mask(this.significand));
    }

    public BigInteger getFullSignificand(BigInteger value) {
        return value.and(this.mask(this.significand + this.getOffset()));
    }

    @Override
    public boolean isPositive(BigInteger value) {
        return !this.isNegative(value);
    }

    @Override
    public boolean isNegative(BigInteger value) {
        return value.testBit(this.exponent + this.significand + this.getOffset());
    }

    @Override
    public boolean isInfinity(BigInteger value) {
        if (this.getExponent(value).compareTo(this.mask(this.exponent)) != 0) {
            return false;
        }
        return this.getSignificand(value).compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public boolean isPositiveInfinity(BigInteger value) {
        return this.isPositive(value) && this.isInfinity(value);
    }

    @Override
    public boolean isNegativeInfinity(BigInteger value) {
        return this.isNegative(value) && this.isInfinity(value);
    }

    @Override
    public BigInteger getPositiveInfinity() {
        return this.memoize(0, () -> BigInteger.ZERO.or(this.mask(this.exponent + this.getOffset())).shiftLeft(this.significand));
    }

    @Override
    public BigInteger getNegativeInfinity() {
        return this.memoize(1, () -> BigInteger.ONE.shiftLeft(this.exponent + this.getOffset()).or(this.mask(this.exponent + this.getOffset())).shiftLeft(this.significand));
    }

    @Override
    public boolean isNaN(BigInteger value) {
        if (this.getExponent(value).compareTo(this.mask(this.exponent)) != 0) {
            return false;
        }
        return this.getSignificand(value).compareTo(BigInteger.ZERO) != 0;
    }

    @Override
    public boolean isQuietNaN(BigInteger value) {
        return this.isNaN(value) && this.getSignificand(value).testBit(this.significand - 1);
    }

    @Override
    public boolean isSignalingNaN(BigInteger value) {
        return this.isNaN(value) && !this.getSignificand(value).testBit(this.significand - 1);
    }

    @Override
    public BigInteger getQuietNaN(int signum) {
        return BigInteger.ZERO.or(this.mask(this.exponent + this.getOffset())).shiftLeft(1).or(BigInteger.ONE).shiftLeft(this.significand - 1).or(BigInteger.ONE).multiply(BigInteger.valueOf(signum));
    }

    @Override
    public BigInteger getSignalingNaN(int signum) {
        return BigInteger.ZERO.or(this.mask(this.exponent + this.getOffset())).shiftLeft(this.significand).or(BigInteger.ONE).multiply(BigInteger.valueOf(signum));
    }

    @Override
    public BigInteger getNaN(int signum) {
        return BigInteger.ZERO.or(this.mask(this.exponent + this.significand + this.getOffset())).multiply(BigInteger.valueOf(signum));
    }

    @Override
    public BigInteger getZero(int signum) {
        return signum == -1 ? BigInteger.ONE.shiftLeft(this.exponent + this.significand + this.getOffset()) : BigInteger.ZERO;
    }

    @Override
    public T getMinSubnormalValue() {
        return (T)this.memoize(2, () -> (Binary)this.factory.create(1, this.pow2exp1().multiply(this.pow2mant())));
    }

    @Override
    public T getMinValue() {
        return (T)this.memoize(3, () -> (Binary)this.factory.create(this.pow2exp1()));
    }

    @Override
    public T getMaxValue() {
        return (T)this.memoize(4, () -> (Binary)this.factory.create(1, BigDecimal.TWO.subtract(this.pow2mant()).multiply(this.pow2(this.getExponentRange().getValue() - 1))));
    }

    @Override
    public BigDecimal getEpsilon() {
        return this.memoize(5, () -> {
            BigInteger rawOne = BigInteger.ZERO.or(this.mask(this.exponent - 1)).shiftLeft(this.significand + this.getOffset());
            if (!this.implicit) {
                rawOne = rawOne.or(BigInteger.ONE.shiftLeft(this.significand - 1 + this.getOffset()));
            }
            BigDecimal one = this.decode(rawOne.or(BigInteger.ONE)).getBigDecimal();
            return one.subtract(BigDecimal.ONE);
        });
    }

    @Override
    public Map.Entry<Integer, Integer> getExponentRange() {
        return this.memoize(6, () -> {
            int bias = this.getBias();
            return Map.entry(2 - bias, (1 << this.exponent) - 1 - bias);
        });
    }

    public Map.Entry<Integer, Integer> get10ExponentRange() {
        return this.memoize(7, () -> {
            BigDecimal min = this.getMinValue().getBigDecimal();
            BigDecimal max = this.getMaxValue().getBigDecimal();
            return Map.entry(min.precision() - min.scale() - 1, max.precision() - max.scale() - 1);
        });
    }

    public int getDecimalDigits() {
        return this.memoize(8, () -> BigDecimal.valueOf(this.significand - 1 + this.getOffset()).multiply(LOG10_2).round(FLOOR).intValue());
    }
}

