/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary64
extends Binary<Binary64> {
    public static final FloatingFactory<Binary64> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary64> CODEC = new BinaryCodec<Binary64>(11, 52, true, FACTORY);
    public static final Binary64 POSITIVE_INFINITY = new Binary64(1, FloatingType.INFINITE);
    public static final Binary64 NEGATIVE_INFINITY = new Binary64(-1, FloatingType.INFINITE);
    public static final Binary64 QUIET_NAN = new Binary64(1, FloatingType.QUIET_NAN);
    public static final Binary64 SIGNALING_NAN = new Binary64(1, FloatingType.SIGNALING_NAN);
    public static final Binary64 MAX_VALUE = (Binary64)CODEC.getMaxValue();
    public static final Binary64 MIN_VALUE = (Binary64)CODEC.getMinSubnormalValue();
    public static final Binary64 MIN_NORMAL = (Binary64)CODEC.getMinValue();

    private Binary64(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary64(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary64> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary64> {
        private Binary64Factory() {
        }

        @Override
        public Binary64 create(int signum, BigDecimal value) {
            return new Binary64(signum, value);
        }

        @Override
        public Binary64 create(int signum, FloatingType type) {
            return new Binary64(signum, type);
        }
    }
}

