/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754;

import at.syntaxerror.ieee754.Floating;
import at.syntaxerror.ieee754.FloatingType;
import java.math.BigDecimal;

public interface FloatingFactory<T extends Floating<T>> {
    public T create(int var1, FloatingType var2);

    public T create(int var1, BigDecimal var2);

    default public T create(BigDecimal value) {
        int signum = value.signum();
        return this.create(signum == 0 ? 1 : signum, value);
    }

    default public T create(Number value) {
        return this.create(new BigDecimal(value.doubleValue()));
    }
}

