/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754;

import at.syntaxerror.ieee754.FloatingCodec;
import at.syntaxerror.ieee754.FloatingType;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class Floating<T extends Floating<T>>
extends Number
implements Comparable<T> {
    public static final int POSITIVE = 1;
    public static final int NEGATIVE = -1;
    private final int signum;
    private final FloatingType type;
    private final BigDecimal value;
    private BigInteger encoded;

    public Floating(int signum, BigDecimal value) {
        if (signum != -1 && signum != 1) {
            throw new IllegalArgumentException("Signum out of range");
        }
        this.signum = signum;
        if (value.compareTo(BigDecimal.ZERO) != 0 && signum != value.signum()) {
            throw new IllegalArgumentException("Signum mismatch");
        }
        if (this.getCodec() == null || !this.getCodec().initialized) {
            this.value = value;
            this.type = FloatingType.FINITE;
            return;
        }
        if (value.abs().compareTo(((Floating)this.getCodec().getMaxValue()).getBigDecimal()) > 0) {
            this.value = null;
            this.type = FloatingType.INFINITE;
        } else if (value.abs().compareTo(((Floating)this.getCodec().getMinSubnormalValue()).getBigDecimal()) < 0) {
            this.value = BigDecimal.ZERO;
            this.type = FloatingType.FINITE;
        } else {
            this.value = value;
            this.type = FloatingType.FINITE;
        }
    }

    public Floating(int signum, FloatingType type) {
        if (signum != -1 && signum != 1) {
            throw new IllegalArgumentException("Signum out of range");
        }
        if (type == FloatingType.FINITE) {
            throw new IllegalArgumentException("Constructor not suitable for finite type");
        }
        this.signum = signum;
        this.type = type;
        this.value = null;
    }

    public BigDecimal getBigDecimal() {
        if (this.type != FloatingType.FINITE) {
            throw new UnsupportedOperationException("BigDecimal is not supported for non-finite types");
        }
        return this.value;
    }

    public int getSignum() {
        return this.signum;
    }

    public boolean isPositive() {
        return this.signum == 1;
    }

    public boolean isNegative() {
        return this.signum == -1;
    }

    public boolean isFinite() {
        return this.type == FloatingType.FINITE;
    }

    public boolean isNaN() {
        return this.type == FloatingType.SIGNALING_NAN || this.type == FloatingType.QUIET_NAN;
    }

    public boolean isSignalingNaN() {
        return this.type == FloatingType.SIGNALING_NAN;
    }

    public boolean isQuietNaN() {
        return this.type == FloatingType.QUIET_NAN;
    }

    public boolean isInfinity() {
        return this.type == FloatingType.INFINITE;
    }

    public boolean isPositiveInfinity() {
        return this.isInfinity() && this.isPositive();
    }

    public boolean isNegativeInfinity() {
        return this.isInfinity() && this.isNegative();
    }

    public boolean isZero() {
        return this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isPositiveZero() {
        return this.isZero() && !this.isNegative();
    }

    public boolean isNegativeZero() {
        return this.isNegative() && this.isNegative();
    }

    public BigInteger encode() {
        return this.encoded == null ? (this.encoded = this.getCodec().encode(this)) : this.encoded;
    }

    @Override
    public int intValue() {
        if (this.type != FloatingType.FINITE) {
            throw new UnsupportedOperationException("Cannot convert non-finite number to integer");
        }
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        if (this.type != FloatingType.FINITE) {
            throw new UnsupportedOperationException("Cannot convert non-finite number to integer");
        }
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        switch (this.type) {
            case INFINITE: {
                return this.isPositiveInfinity() ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            case FINITE: {
                return this.value.doubleValue();
            }
        }
        return Double.NaN;
    }

    @Override
    public int compareTo(T o) {
        return this.isFinite() && ((Floating)o).isFinite() ? this.value.compareTo(((Floating)o).getBigDecimal()) : Double.compare(this.doubleValue(), ((Floating)o).doubleValue());
    }

    public String toString() {
        switch (this.type) {
            case INFINITE: {
                return (this.isNegative() ? "-" : "") + "Infinity";
            }
            case FINITE: {
                return this.getBigDecimal().toString();
            }
        }
        return "NaN";
    }

    public abstract FloatingCodec<T> getCodec();
}

