/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.decimal;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.decimal.Decimal;
import at.syntaxerror.ieee754.decimal.DecimalCodec;
import java.math.BigDecimal;

public final class Decimal64
extends Decimal<Decimal64> {
    public static final FloatingFactory<Decimal64> FACTORY = new Binary32Factory();
    public static final DecimalCodec<Decimal64> CODEC = new DecimalCodec<Decimal64>(13, 50, FACTORY);
    public static final Decimal64 POSITIVE_INFINITY = new Decimal64(1, FloatingType.INFINITE);
    public static final Decimal64 NEGATIVE_INFINITY = new Decimal64(-1, FloatingType.INFINITE);
    public static final Decimal64 QUIET_NAN = new Decimal64(1, FloatingType.QUIET_NAN);
    public static final Decimal64 SIGNALING_NAN = new Decimal64(1, FloatingType.SIGNALING_NAN);
    public static final Decimal64 MAX_VALUE = (Decimal64)CODEC.getMaxValue();
    public static final Decimal64 MIN_VALUE = (Decimal64)CODEC.getMinSubnormalValue();
    public static final Decimal64 MIN_NORMAL = (Decimal64)CODEC.getMinValue();

    private Decimal64(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Decimal64(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public DecimalCodec<Decimal64> getCodec() {
        return CODEC;
    }

    private static class Binary32Factory
    implements FloatingFactory<Decimal64> {
        private Binary32Factory() {
        }

        @Override
        public Decimal64 create(int signum, BigDecimal value) {
            return new Decimal64(signum, value);
        }

        @Override
        public Decimal64 create(int signum, FloatingType type) {
            return new Decimal64(signum, type);
        }
    }
}

