/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.decimal;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.decimal.Decimal;
import at.syntaxerror.ieee754.decimal.DecimalCodec;
import java.math.BigDecimal;

public final class Decimal32
extends Decimal<Decimal32> {
    public static final FloatingFactory<Decimal32> FACTORY = new Binary32Factory();
    public static final DecimalCodec<Decimal32> CODEC = new DecimalCodec<Decimal32>(11, 20, FACTORY);
    public static final Decimal32 POSITIVE_INFINITY = new Decimal32(1, FloatingType.INFINITE);
    public static final Decimal32 NEGATIVE_INFINITY = new Decimal32(-1, FloatingType.INFINITE);
    public static final Decimal32 QUIET_NAN = new Decimal32(1, FloatingType.QUIET_NAN);
    public static final Decimal32 SIGNALING_NAN = new Decimal32(1, FloatingType.SIGNALING_NAN);
    public static final Decimal32 MAX_VALUE = (Decimal32)CODEC.getMaxValue();
    public static final Decimal32 MIN_VALUE = (Decimal32)CODEC.getMinSubnormalValue();
    public static final Decimal32 MIN_NORMAL = (Decimal32)CODEC.getMinValue();

    private Decimal32(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Decimal32(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public DecimalCodec<Decimal32> getCodec() {
        return CODEC;
    }

    private static class Binary32Factory
    implements FloatingFactory<Decimal32> {
        private Binary32Factory() {
        }

        @Override
        public Decimal32 create(int signum, BigDecimal value) {
            return new Decimal32(signum, value);
        }

        @Override
        public Decimal32 create(int signum, FloatingType type) {
            return new Decimal32(signum, type);
        }
    }
}

