/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.decimal;

import at.syntaxerror.ieee754.Floating;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.decimal.DecimalCodec;
import at.syntaxerror.ieee754.decimal.DecimalCoding;
import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.NonNull;

public abstract class Decimal<T extends Decimal<T>>
extends Floating<T> {
    @NonNull
    public static DecimalCoding DEFAULT_CODING = DecimalCoding.BINARY_INTEGER_DECIMAL;
    private BigInteger encodedDPD;
    private BigInteger encodedBIP;

    public Decimal(int signum, FloatingType type) {
        super(signum, type);
    }

    public Decimal(int signum, BigDecimal value) {
        super(signum, value);
    }

    @Override
    public BigInteger encode() {
        return DEFAULT_CODING == DecimalCoding.DENSLY_PACKED_DECIMAL ? this.encodeDPD() : this.encodeBID();
    }

    public BigInteger encodeDPD() {
        return this.encodedDPD == null ? (this.encodedDPD = ((DecimalCodec)this.getCodec()).encodeDPD(this)) : this.encodedDPD;
    }

    public BigInteger encodeBID() {
        return this.encodedBIP == null ? (this.encodedBIP = ((DecimalCodec)this.getCodec()).encodeBID(this)) : this.encodedBIP;
    }
}

