/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary80
extends Binary<Binary80> {
    public static final FloatingFactory<Binary80> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary80> CODEC = new BinaryCodec<Binary80>(15, 63, false, FACTORY);
    public static final Binary80 POSITIVE_INFINITY = new Binary80(1, FloatingType.INFINITE);
    public static final Binary80 NEGATIVE_INFINITY = new Binary80(-1, FloatingType.INFINITE);
    public static final Binary80 QUIET_NAN = new Binary80(1, FloatingType.QUIET_NAN);
    public static final Binary80 SIGNALING_NAN = new Binary80(1, FloatingType.SIGNALING_NAN);
    public static final Binary80 MAX_VALUE = (Binary80)CODEC.getMaxValue();
    public static final Binary80 MIN_VALUE = (Binary80)CODEC.getMinSubnormalValue();
    public static final Binary80 MIN_NORMAL = (Binary80)CODEC.getMinValue();

    private Binary80(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary80(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary80> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary80> {
        private Binary64Factory() {
        }

        @Override
        public Binary80 create(int signum, BigDecimal value) {
            return new Binary80(signum, value);
        }

        @Override
        public Binary80 create(int signum, FloatingType type) {
            return new Binary80(signum, type);
        }
    }
}

