/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary512
extends Binary<Binary512> {
    public static final FloatingFactory<Binary512> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary512> CODEC = new BinaryCodec<Binary512>(23, 488, true, FACTORY);
    public static final Binary512 POSITIVE_INFINITY = new Binary512(1, FloatingType.INFINITE);
    public static final Binary512 NEGATIVE_INFINITY = new Binary512(-1, FloatingType.INFINITE);
    public static final Binary512 QUIET_NAN = new Binary512(1, FloatingType.QUIET_NAN);
    public static final Binary512 SIGNALING_NAN = new Binary512(1, FloatingType.SIGNALING_NAN);
    public static final Binary512 MAX_VALUE = (Binary512)CODEC.getMaxValue();
    public static final Binary512 MIN_VALUE = (Binary512)CODEC.getMinSubnormalValue();
    public static final Binary512 MIN_NORMAL = (Binary512)CODEC.getMinValue();

    private Binary512(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary512(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary512> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary512> {
        private Binary64Factory() {
        }

        @Override
        public Binary512 create(int signum, BigDecimal value) {
            return new Binary512(signum, value);
        }

        @Override
        public Binary512 create(int signum, FloatingType type) {
            return new Binary512(signum, type);
        }
    }
}

