/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary32
extends Binary<Binary32> {
    public static final FloatingFactory<Binary32> FACTORY = new Binary32Factory();
    public static final BinaryCodec<Binary32> CODEC = new BinaryCodec<Binary32>(8, 23, true, FACTORY);
    public static final Binary32 POSITIVE_INFINITY = new Binary32(1, FloatingType.INFINITE);
    public static final Binary32 NEGATIVE_INFINITY = new Binary32(-1, FloatingType.INFINITE);
    public static final Binary32 QUIET_NAN = new Binary32(1, FloatingType.QUIET_NAN);
    public static final Binary32 SIGNALING_NAN = new Binary32(1, FloatingType.SIGNALING_NAN);
    public static final Binary32 MAX_VALUE = (Binary32)CODEC.getMaxValue();
    public static final Binary32 MIN_VALUE = (Binary32)CODEC.getMinSubnormalValue();
    public static final Binary32 MIN_NORMAL = (Binary32)CODEC.getMinValue();

    private Binary32(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary32(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary32> getCodec() {
        return CODEC;
    }

    private static class Binary32Factory
    implements FloatingFactory<Binary32> {
        private Binary32Factory() {
        }

        @Override
        public Binary32 create(int signum, BigDecimal value) {
            return new Binary32(signum, value);
        }

        @Override
        public Binary32 create(int signum, FloatingType type) {
            return new Binary32(signum, type);
        }
    }
}

