/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary256
extends Binary<Binary256> {
    public static final FloatingFactory<Binary256> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary256> CODEC = new BinaryCodec<Binary256>(19, 236, true, FACTORY);
    public static final Binary256 POSITIVE_INFINITY = new Binary256(1, FloatingType.INFINITE);
    public static final Binary256 NEGATIVE_INFINITY = new Binary256(-1, FloatingType.INFINITE);
    public static final Binary256 QUIET_NAN = new Binary256(1, FloatingType.QUIET_NAN);
    public static final Binary256 SIGNALING_NAN = new Binary256(1, FloatingType.SIGNALING_NAN);
    public static final Binary256 MAX_VALUE = (Binary256)CODEC.getMaxValue();
    public static final Binary256 MIN_VALUE = (Binary256)CODEC.getMinSubnormalValue();
    public static final Binary256 MIN_NORMAL = (Binary256)CODEC.getMinValue();

    private Binary256(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary256(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary256> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary256> {
        private Binary64Factory() {
        }

        @Override
        public Binary256 create(int signum, BigDecimal value) {
            return new Binary256(signum, value);
        }

        @Override
        public Binary256 create(int signum, FloatingType type) {
            return new Binary256(signum, type);
        }
    }
}

