/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary2048
extends Binary<Binary2048> {
    public static final FloatingFactory<Binary2048> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary2048> CODEC = new BinaryCodec<Binary2048>(31, 2016, true, FACTORY);
    public static final Binary2048 POSITIVE_INFINITY = new Binary2048(1, FloatingType.INFINITE);
    public static final Binary2048 NEGATIVE_INFINITY = new Binary2048(-1, FloatingType.INFINITE);
    public static final Binary2048 QUIET_NAN = new Binary2048(1, FloatingType.QUIET_NAN);
    public static final Binary2048 SIGNALING_NAN = new Binary2048(1, FloatingType.SIGNALING_NAN);
    public static final Binary2048 MAX_VALUE = (Binary2048)CODEC.getMaxValue();
    public static final Binary2048 MIN_VALUE = (Binary2048)CODEC.getMinSubnormalValue();
    public static final Binary2048 MIN_NORMAL = (Binary2048)CODEC.getMinValue();

    private Binary2048(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary2048(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary2048> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary2048> {
        private Binary64Factory() {
        }

        @Override
        public Binary2048 create(int signum, BigDecimal value) {
            return new Binary2048(signum, value);
        }

        @Override
        public Binary2048 create(int signum, FloatingType type) {
            return new Binary2048(signum, type);
        }
    }
}

