/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary16
extends Binary<Binary16> {
    public static final FloatingFactory<Binary16> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary16> CODEC = new BinaryCodec<Binary16>(5, 10, true, FACTORY);
    public static final Binary16 POSITIVE_INFINITY = new Binary16(1, FloatingType.INFINITE);
    public static final Binary16 NEGATIVE_INFINITY = new Binary16(-1, FloatingType.INFINITE);
    public static final Binary16 QUIET_NAN = new Binary16(1, FloatingType.QUIET_NAN);
    public static final Binary16 SIGNALING_NAN = new Binary16(1, FloatingType.SIGNALING_NAN);
    public static final Binary16 MAX_VALUE = (Binary16)CODEC.getMaxValue();
    public static final Binary16 MIN_VALUE = (Binary16)CODEC.getMinSubnormalValue();
    public static final Binary16 MIN_NORMAL = (Binary16)CODEC.getMinValue();

    private Binary16(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary16(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary16> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary16> {
        private Binary64Factory() {
        }

        @Override
        public Binary16 create(int signum, BigDecimal value) {
            return new Binary16(signum, value);
        }

        @Override
        public Binary16 create(int signum, FloatingType type) {
            return new Binary16(signum, type);
        }
    }
}

