/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary128
extends Binary<Binary128> {
    public static final FloatingFactory<Binary128> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary128> CODEC = new BinaryCodec<Binary128>(15, 112, true, FACTORY);
    public static final Binary128 POSITIVE_INFINITY = new Binary128(1, FloatingType.INFINITE);
    public static final Binary128 NEGATIVE_INFINITY = new Binary128(-1, FloatingType.INFINITE);
    public static final Binary128 QUIET_NAN = new Binary128(1, FloatingType.QUIET_NAN);
    public static final Binary128 SIGNALING_NAN = new Binary128(1, FloatingType.SIGNALING_NAN);
    public static final Binary128 MAX_VALUE = (Binary128)CODEC.getMaxValue();
    public static final Binary128 MIN_VALUE = (Binary128)CODEC.getMinSubnormalValue();
    public static final Binary128 MIN_NORMAL = (Binary128)CODEC.getMinValue();

    private Binary128(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary128(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary128> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary128> {
        private Binary64Factory() {
        }

        @Override
        public Binary128 create(int signum, BigDecimal value) {
            return new Binary128(signum, value);
        }

        @Override
        public Binary128 create(int signum, FloatingType type) {
            return new Binary128(signum, type);
        }
    }
}

