/*
 * Decompiled with CFR 0.152.
 */
package at.syntaxerror.ieee754.binary;

import at.syntaxerror.ieee754.FloatingFactory;
import at.syntaxerror.ieee754.FloatingType;
import at.syntaxerror.ieee754.binary.Binary;
import at.syntaxerror.ieee754.binary.BinaryCodec;
import java.math.BigDecimal;

public final class Binary1024
extends Binary<Binary1024> {
    public static final FloatingFactory<Binary1024> FACTORY = new Binary64Factory();
    public static final BinaryCodec<Binary1024> CODEC = new BinaryCodec<Binary1024>(27, 996, true, FACTORY);
    public static final Binary1024 POSITIVE_INFINITY = new Binary1024(1, FloatingType.INFINITE);
    public static final Binary1024 NEGATIVE_INFINITY = new Binary1024(-1, FloatingType.INFINITE);
    public static final Binary1024 QUIET_NAN = new Binary1024(1, FloatingType.QUIET_NAN);
    public static final Binary1024 SIGNALING_NAN = new Binary1024(1, FloatingType.SIGNALING_NAN);
    public static final Binary1024 MAX_VALUE = (Binary1024)CODEC.getMaxValue();
    public static final Binary1024 MIN_VALUE = (Binary1024)CODEC.getMinSubnormalValue();
    public static final Binary1024 MIN_NORMAL = (Binary1024)CODEC.getMinValue();

    private Binary1024(int signum, BigDecimal value) {
        super(signum, value);
    }

    private Binary1024(int signum, FloatingType type) {
        super(signum, type);
    }

    @Override
    public BinaryCodec<Binary1024> getCodec() {
        return CODEC;
    }

    private static class Binary64Factory
    implements FloatingFactory<Binary1024> {
        private Binary64Factory() {
        }

        @Override
        public Binary1024 create(int signum, BigDecimal value) {
            return new Binary1024(signum, value);
        }

        @Override
        public Binary1024 create(int signum, FloatingType type) {
            return new Binary1024(signum, type);
        }
    }
}

